/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appsync.AppSyncAsyncClient;
import software.amazon.awssdk.services.appsync.internal.UserAgentUtils;
import software.amazon.awssdk.services.appsync.model.ListTypesByAssociationRequest;
import software.amazon.awssdk.services.appsync.model.ListTypesByAssociationResponse;
import software.amazon.awssdk.services.appsync.model.Type;

public class ListTypesByAssociationPublisher
implements SdkPublisher<ListTypesByAssociationResponse> {
    private final AppSyncAsyncClient client;
    private final ListTypesByAssociationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTypesByAssociationPublisher(AppSyncAsyncClient client, ListTypesByAssociationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTypesByAssociationPublisher(AppSyncAsyncClient client, ListTypesByAssociationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTypesByAssociationResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTypesByAssociationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Type> types() {
        Function<ListTypesByAssociationResponse, Iterator> getIterator = response -> {
            if (response != null && response.types() != null) {
                return response.types().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTypesByAssociationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTypesByAssociationResponseFetcher
    implements AsyncPageFetcher<ListTypesByAssociationResponse> {
        private ListTypesByAssociationResponseFetcher() {
        }

        public boolean hasNextPage(ListTypesByAssociationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTypesByAssociationResponse> nextPage(ListTypesByAssociationResponse previousPage) {
            if (previousPage == null) {
                return ListTypesByAssociationPublisher.this.client.listTypesByAssociation(ListTypesByAssociationPublisher.this.firstRequest);
            }
            return ListTypesByAssociationPublisher.this.client.listTypesByAssociation((ListTypesByAssociationRequest)((Object)ListTypesByAssociationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

