/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appsync.model.AuthMode;
import software.amazon.awssdk.services.appsync.model.AuthModesCopier;
import software.amazon.awssdk.services.appsync.model.AuthProvider;
import software.amazon.awssdk.services.appsync.model.AuthProvidersCopier;
import software.amazon.awssdk.services.appsync.model.EventLogConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventConfig> {
    private static final SdkField<List<AuthProvider>> AUTH_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("authProviders").getter(EventConfig.getter(EventConfig::authProviders)).setter(EventConfig.setter(Builder::authProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuthProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AuthMode>> CONNECTION_AUTH_MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("connectionAuthModes").getter(EventConfig.getter(EventConfig::connectionAuthModes)).setter(EventConfig.setter(Builder::connectionAuthModes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionAuthModes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuthMode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AuthMode>> DEFAULT_PUBLISH_AUTH_MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("defaultPublishAuthModes").getter(EventConfig.getter(EventConfig::defaultPublishAuthModes)).setter(EventConfig.setter(Builder::defaultPublishAuthModes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultPublishAuthModes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuthMode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AuthMode>> DEFAULT_SUBSCRIBE_AUTH_MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("defaultSubscribeAuthModes").getter(EventConfig.getter(EventConfig::defaultSubscribeAuthModes)).setter(EventConfig.setter(Builder::defaultSubscribeAuthModes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultSubscribeAuthModes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuthMode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EventLogConfig> LOG_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logConfig").getter(EventConfig.getter(EventConfig::logConfig)).setter(EventConfig.setter(Builder::logConfig)).constructor(EventLogConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_PROVIDERS_FIELD, CONNECTION_AUTH_MODES_FIELD, DEFAULT_PUBLISH_AUTH_MODES_FIELD, DEFAULT_SUBSCRIBE_AUTH_MODES_FIELD, LOG_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("authProviders", AUTH_PROVIDERS_FIELD);
            this.put("connectionAuthModes", CONNECTION_AUTH_MODES_FIELD);
            this.put("defaultPublishAuthModes", DEFAULT_PUBLISH_AUTH_MODES_FIELD);
            this.put("defaultSubscribeAuthModes", DEFAULT_SUBSCRIBE_AUTH_MODES_FIELD);
            this.put("logConfig", LOG_CONFIG_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<AuthProvider> authProviders;
    private final List<AuthMode> connectionAuthModes;
    private final List<AuthMode> defaultPublishAuthModes;
    private final List<AuthMode> defaultSubscribeAuthModes;
    private final EventLogConfig logConfig;

    private EventConfig(BuilderImpl builder) {
        this.authProviders = builder.authProviders;
        this.connectionAuthModes = builder.connectionAuthModes;
        this.defaultPublishAuthModes = builder.defaultPublishAuthModes;
        this.defaultSubscribeAuthModes = builder.defaultSubscribeAuthModes;
        this.logConfig = builder.logConfig;
    }

    public final boolean hasAuthProviders() {
        return this.authProviders != null && !(this.authProviders instanceof SdkAutoConstructList);
    }

    public final List<AuthProvider> authProviders() {
        return this.authProviders;
    }

    public final boolean hasConnectionAuthModes() {
        return this.connectionAuthModes != null && !(this.connectionAuthModes instanceof SdkAutoConstructList);
    }

    public final List<AuthMode> connectionAuthModes() {
        return this.connectionAuthModes;
    }

    public final boolean hasDefaultPublishAuthModes() {
        return this.defaultPublishAuthModes != null && !(this.defaultPublishAuthModes instanceof SdkAutoConstructList);
    }

    public final List<AuthMode> defaultPublishAuthModes() {
        return this.defaultPublishAuthModes;
    }

    public final boolean hasDefaultSubscribeAuthModes() {
        return this.defaultSubscribeAuthModes != null && !(this.defaultSubscribeAuthModes instanceof SdkAutoConstructList);
    }

    public final List<AuthMode> defaultSubscribeAuthModes() {
        return this.defaultSubscribeAuthModes;
    }

    public final EventLogConfig logConfig() {
        return this.logConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthProviders() ? this.authProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionAuthModes() ? this.connectionAuthModes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultPublishAuthModes() ? this.defaultPublishAuthModes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultSubscribeAuthModes() ? this.defaultSubscribeAuthModes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventConfig)) {
            return false;
        }
        EventConfig other = (EventConfig)obj;
        return this.hasAuthProviders() == other.hasAuthProviders() && Objects.equals(this.authProviders(), other.authProviders()) && this.hasConnectionAuthModes() == other.hasConnectionAuthModes() && Objects.equals(this.connectionAuthModes(), other.connectionAuthModes()) && this.hasDefaultPublishAuthModes() == other.hasDefaultPublishAuthModes() && Objects.equals(this.defaultPublishAuthModes(), other.defaultPublishAuthModes()) && this.hasDefaultSubscribeAuthModes() == other.hasDefaultSubscribeAuthModes() && Objects.equals(this.defaultSubscribeAuthModes(), other.defaultSubscribeAuthModes()) && Objects.equals(this.logConfig(), other.logConfig());
    }

    public final String toString() {
        return ToString.builder((String)"EventConfig").add("AuthProviders", this.hasAuthProviders() ? this.authProviders() : null).add("ConnectionAuthModes", this.hasConnectionAuthModes() ? this.connectionAuthModes() : null).add("DefaultPublishAuthModes", this.hasDefaultPublishAuthModes() ? this.defaultPublishAuthModes() : null).add("DefaultSubscribeAuthModes", this.hasDefaultSubscribeAuthModes() ? this.defaultSubscribeAuthModes() : null).add("LogConfig", (Object)this.logConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authProviders": {
                return Optional.ofNullable(clazz.cast(this.authProviders()));
            }
            case "connectionAuthModes": {
                return Optional.ofNullable(clazz.cast(this.connectionAuthModes()));
            }
            case "defaultPublishAuthModes": {
                return Optional.ofNullable(clazz.cast(this.defaultPublishAuthModes()));
            }
            case "defaultSubscribeAuthModes": {
                return Optional.ofNullable(clazz.cast(this.defaultSubscribeAuthModes()));
            }
            case "logConfig": {
                return Optional.ofNullable(clazz.cast(this.logConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EventConfig, T> g) {
        return obj -> g.apply((EventConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AuthProvider> authProviders = DefaultSdkAutoConstructList.getInstance();
        private List<AuthMode> connectionAuthModes = DefaultSdkAutoConstructList.getInstance();
        private List<AuthMode> defaultPublishAuthModes = DefaultSdkAutoConstructList.getInstance();
        private List<AuthMode> defaultSubscribeAuthModes = DefaultSdkAutoConstructList.getInstance();
        private EventLogConfig logConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(EventConfig model) {
            this.authProviders(model.authProviders);
            this.connectionAuthModes(model.connectionAuthModes);
            this.defaultPublishAuthModes(model.defaultPublishAuthModes);
            this.defaultSubscribeAuthModes(model.defaultSubscribeAuthModes);
            this.logConfig(model.logConfig);
        }

        public final List<AuthProvider.Builder> getAuthProviders() {
            List<AuthProvider.Builder> result = AuthProvidersCopier.copyToBuilder(this.authProviders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthProviders(Collection<AuthProvider.BuilderImpl> authProviders) {
            this.authProviders = AuthProvidersCopier.copyFromBuilder(authProviders);
        }

        @Override
        public final Builder authProviders(Collection<AuthProvider> authProviders) {
            this.authProviders = AuthProvidersCopier.copy(authProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authProviders(AuthProvider ... authProviders) {
            this.authProviders(Arrays.asList(authProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authProviders(Consumer<AuthProvider.Builder> ... authProviders) {
            this.authProviders(Stream.of(authProviders).map(c -> (AuthProvider)((AuthProvider.Builder)AuthProvider.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AuthMode.Builder> getConnectionAuthModes() {
            List<AuthMode.Builder> result = AuthModesCopier.copyToBuilder(this.connectionAuthModes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectionAuthModes(Collection<AuthMode.BuilderImpl> connectionAuthModes) {
            this.connectionAuthModes = AuthModesCopier.copyFromBuilder(connectionAuthModes);
        }

        @Override
        public final Builder connectionAuthModes(Collection<AuthMode> connectionAuthModes) {
            this.connectionAuthModes = AuthModesCopier.copy(connectionAuthModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionAuthModes(AuthMode ... connectionAuthModes) {
            this.connectionAuthModes(Arrays.asList(connectionAuthModes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionAuthModes(Consumer<AuthMode.Builder> ... connectionAuthModes) {
            this.connectionAuthModes(Stream.of(connectionAuthModes).map(c -> (AuthMode)((AuthMode.Builder)AuthMode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AuthMode.Builder> getDefaultPublishAuthModes() {
            List<AuthMode.Builder> result = AuthModesCopier.copyToBuilder(this.defaultPublishAuthModes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefaultPublishAuthModes(Collection<AuthMode.BuilderImpl> defaultPublishAuthModes) {
            this.defaultPublishAuthModes = AuthModesCopier.copyFromBuilder(defaultPublishAuthModes);
        }

        @Override
        public final Builder defaultPublishAuthModes(Collection<AuthMode> defaultPublishAuthModes) {
            this.defaultPublishAuthModes = AuthModesCopier.copy(defaultPublishAuthModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultPublishAuthModes(AuthMode ... defaultPublishAuthModes) {
            this.defaultPublishAuthModes(Arrays.asList(defaultPublishAuthModes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultPublishAuthModes(Consumer<AuthMode.Builder> ... defaultPublishAuthModes) {
            this.defaultPublishAuthModes(Stream.of(defaultPublishAuthModes).map(c -> (AuthMode)((AuthMode.Builder)AuthMode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AuthMode.Builder> getDefaultSubscribeAuthModes() {
            List<AuthMode.Builder> result = AuthModesCopier.copyToBuilder(this.defaultSubscribeAuthModes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefaultSubscribeAuthModes(Collection<AuthMode.BuilderImpl> defaultSubscribeAuthModes) {
            this.defaultSubscribeAuthModes = AuthModesCopier.copyFromBuilder(defaultSubscribeAuthModes);
        }

        @Override
        public final Builder defaultSubscribeAuthModes(Collection<AuthMode> defaultSubscribeAuthModes) {
            this.defaultSubscribeAuthModes = AuthModesCopier.copy(defaultSubscribeAuthModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultSubscribeAuthModes(AuthMode ... defaultSubscribeAuthModes) {
            this.defaultSubscribeAuthModes(Arrays.asList(defaultSubscribeAuthModes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultSubscribeAuthModes(Consumer<AuthMode.Builder> ... defaultSubscribeAuthModes) {
            this.defaultSubscribeAuthModes(Stream.of(defaultSubscribeAuthModes).map(c -> (AuthMode)((AuthMode.Builder)AuthMode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final EventLogConfig.Builder getLogConfig() {
            return this.logConfig != null ? this.logConfig.toBuilder() : null;
        }

        public final void setLogConfig(EventLogConfig.BuilderImpl logConfig) {
            this.logConfig = logConfig != null ? logConfig.build() : null;
        }

        @Override
        public final Builder logConfig(EventLogConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        public EventConfig build() {
            return new EventConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventConfig> {
        public Builder authProviders(Collection<AuthProvider> var1);

        public Builder authProviders(AuthProvider ... var1);

        public Builder authProviders(Consumer<AuthProvider.Builder> ... var1);

        public Builder connectionAuthModes(Collection<AuthMode> var1);

        public Builder connectionAuthModes(AuthMode ... var1);

        public Builder connectionAuthModes(Consumer<AuthMode.Builder> ... var1);

        public Builder defaultPublishAuthModes(Collection<AuthMode> var1);

        public Builder defaultPublishAuthModes(AuthMode ... var1);

        public Builder defaultPublishAuthModes(Consumer<AuthMode.Builder> ... var1);

        public Builder defaultSubscribeAuthModes(Collection<AuthMode> var1);

        public Builder defaultSubscribeAuthModes(AuthMode ... var1);

        public Builder defaultSubscribeAuthModes(Consumer<AuthMode.Builder> ... var1);

        public Builder logConfig(EventLogConfig var1);

        default public Builder logConfig(Consumer<EventLogConfig.Builder> logConfig) {
            return this.logConfig((EventLogConfig)((EventLogConfig.Builder)EventLogConfig.builder().applyMutation(logConfig)).build());
        }
    }
}

