/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appsync.AppSyncAsyncClient;
import software.amazon.awssdk.services.appsync.internal.UserAgentUtils;
import software.amazon.awssdk.services.appsync.model.ListSourceApiAssociationsRequest;
import software.amazon.awssdk.services.appsync.model.ListSourceApiAssociationsResponse;
import software.amazon.awssdk.services.appsync.model.SourceApiAssociationSummary;

public class ListSourceApiAssociationsPublisher
implements SdkPublisher<ListSourceApiAssociationsResponse> {
    private final AppSyncAsyncClient client;
    private final ListSourceApiAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSourceApiAssociationsPublisher(AppSyncAsyncClient client, ListSourceApiAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSourceApiAssociationsPublisher(AppSyncAsyncClient client, ListSourceApiAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSourceApiAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSourceApiAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SourceApiAssociationSummary> sourceApiAssociationSummaries() {
        Function<ListSourceApiAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.sourceApiAssociationSummaries() != null) {
                return response.sourceApiAssociationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSourceApiAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSourceApiAssociationsResponseFetcher
    implements AsyncPageFetcher<ListSourceApiAssociationsResponse> {
        private ListSourceApiAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSourceApiAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSourceApiAssociationsResponse> nextPage(ListSourceApiAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListSourceApiAssociationsPublisher.this.client.listSourceApiAssociations(ListSourceApiAssociationsPublisher.this.firstRequest);
            }
            return ListSourceApiAssociationsPublisher.this.client.listSourceApiAssociations((ListSourceApiAssociationsRequest)((Object)ListSourceApiAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

