/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appsync.model.AdditionalAuthenticationProvider;
import software.amazon.awssdk.services.appsync.model.AdditionalAuthenticationProvidersCopier;
import software.amazon.awssdk.services.appsync.model.AppSyncRequest;
import software.amazon.awssdk.services.appsync.model.AuthenticationType;
import software.amazon.awssdk.services.appsync.model.LogConfig;
import software.amazon.awssdk.services.appsync.model.OpenIDConnectConfig;
import software.amazon.awssdk.services.appsync.model.UserPoolConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGraphqlApiRequest
extends AppSyncRequest
implements ToCopyableBuilder<Builder, UpdateGraphqlApiRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateGraphqlApiRequest.getter(UpdateGraphqlApiRequest::apiId)).setter(UpdateGraphqlApiRequest.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateGraphqlApiRequest.getter(UpdateGraphqlApiRequest::name)).setter(UpdateGraphqlApiRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<LogConfig> LOG_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateGraphqlApiRequest.getter(UpdateGraphqlApiRequest::logConfig)).setter(UpdateGraphqlApiRequest.setter(Builder::logConfig)).constructor(LogConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfig").build()}).build();
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateGraphqlApiRequest.getter(UpdateGraphqlApiRequest::authenticationTypeAsString)).setter(UpdateGraphqlApiRequest.setter(Builder::authenticationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationType").build()}).build();
    private static final SdkField<UserPoolConfig> USER_POOL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateGraphqlApiRequest.getter(UpdateGraphqlApiRequest::userPoolConfig)).setter(UpdateGraphqlApiRequest.setter(Builder::userPoolConfig)).constructor(UserPoolConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPoolConfig").build()}).build();
    private static final SdkField<OpenIDConnectConfig> OPEN_ID_CONNECT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateGraphqlApiRequest.getter(UpdateGraphqlApiRequest::openIDConnectConfig)).setter(UpdateGraphqlApiRequest.setter(Builder::openIDConnectConfig)).constructor(OpenIDConnectConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openIDConnectConfig").build()}).build();
    private static final SdkField<List<AdditionalAuthenticationProvider>> ADDITIONAL_AUTHENTICATION_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateGraphqlApiRequest.getter(UpdateGraphqlApiRequest::additionalAuthenticationProviders)).setter(UpdateGraphqlApiRequest.setter(Builder::additionalAuthenticationProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalAuthenticationProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdditionalAuthenticationProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> XRAY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateGraphqlApiRequest.getter(UpdateGraphqlApiRequest::xrayEnabled)).setter(UpdateGraphqlApiRequest.setter(Builder::xrayEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xrayEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, NAME_FIELD, LOG_CONFIG_FIELD, AUTHENTICATION_TYPE_FIELD, USER_POOL_CONFIG_FIELD, OPEN_ID_CONNECT_CONFIG_FIELD, ADDITIONAL_AUTHENTICATION_PROVIDERS_FIELD, XRAY_ENABLED_FIELD));
    private final String apiId;
    private final String name;
    private final LogConfig logConfig;
    private final String authenticationType;
    private final UserPoolConfig userPoolConfig;
    private final OpenIDConnectConfig openIDConnectConfig;
    private final List<AdditionalAuthenticationProvider> additionalAuthenticationProviders;
    private final Boolean xrayEnabled;

    private UpdateGraphqlApiRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.name = builder.name;
        this.logConfig = builder.logConfig;
        this.authenticationType = builder.authenticationType;
        this.userPoolConfig = builder.userPoolConfig;
        this.openIDConnectConfig = builder.openIDConnectConfig;
        this.additionalAuthenticationProviders = builder.additionalAuthenticationProviders;
        this.xrayEnabled = builder.xrayEnabled;
    }

    public String apiId() {
        return this.apiId;
    }

    public String name() {
        return this.name;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(this.authenticationType);
    }

    public String authenticationTypeAsString() {
        return this.authenticationType;
    }

    public UserPoolConfig userPoolConfig() {
        return this.userPoolConfig;
    }

    public OpenIDConnectConfig openIDConnectConfig() {
        return this.openIDConnectConfig;
    }

    public boolean hasAdditionalAuthenticationProviders() {
        return this.additionalAuthenticationProviders != null && !(this.additionalAuthenticationProviders instanceof SdkAutoConstructList);
    }

    public List<AdditionalAuthenticationProvider> additionalAuthenticationProviders() {
        return this.additionalAuthenticationProviders;
    }

    public Boolean xrayEnabled() {
        return this.xrayEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.openIDConnectConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalAuthenticationProviders());
        hashCode = 31 * hashCode + Objects.hashCode(this.xrayEnabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGraphqlApiRequest)) {
            return false;
        }
        UpdateGraphqlApiRequest other = (UpdateGraphqlApiRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.logConfig(), other.logConfig()) && Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString()) && Objects.equals(this.userPoolConfig(), other.userPoolConfig()) && Objects.equals(this.openIDConnectConfig(), other.openIDConnectConfig()) && Objects.equals(this.additionalAuthenticationProviders(), other.additionalAuthenticationProviders()) && Objects.equals(this.xrayEnabled(), other.xrayEnabled());
    }

    public String toString() {
        return ToString.builder((String)"UpdateGraphqlApiRequest").add("ApiId", (Object)this.apiId()).add("Name", (Object)this.name()).add("LogConfig", (Object)this.logConfig()).add("AuthenticationType", (Object)this.authenticationTypeAsString()).add("UserPoolConfig", (Object)this.userPoolConfig()).add("OpenIDConnectConfig", (Object)this.openIDConnectConfig()).add("AdditionalAuthenticationProviders", this.additionalAuthenticationProviders()).add("XrayEnabled", (Object)this.xrayEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "logConfig": {
                return Optional.ofNullable(clazz.cast(this.logConfig()));
            }
            case "authenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationTypeAsString()));
            }
            case "userPoolConfig": {
                return Optional.ofNullable(clazz.cast(this.userPoolConfig()));
            }
            case "openIDConnectConfig": {
                return Optional.ofNullable(clazz.cast(this.openIDConnectConfig()));
            }
            case "additionalAuthenticationProviders": {
                return Optional.ofNullable(clazz.cast(this.additionalAuthenticationProviders()));
            }
            case "xrayEnabled": {
                return Optional.ofNullable(clazz.cast(this.xrayEnabled()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGraphqlApiRequest, T> g) {
        return obj -> g.apply((UpdateGraphqlApiRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppSyncRequest.BuilderImpl
    implements Builder {
        private String apiId;
        private String name;
        private LogConfig logConfig;
        private String authenticationType;
        private UserPoolConfig userPoolConfig;
        private OpenIDConnectConfig openIDConnectConfig;
        private List<AdditionalAuthenticationProvider> additionalAuthenticationProviders = DefaultSdkAutoConstructList.getInstance();
        private Boolean xrayEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGraphqlApiRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.name(model.name);
            this.logConfig(model.logConfig);
            this.authenticationType(model.authenticationType);
            this.userPoolConfig(model.userPoolConfig);
            this.openIDConnectConfig(model.openIDConnectConfig);
            this.additionalAuthenticationProviders(model.additionalAuthenticationProviders);
            this.xrayEnabled(model.xrayEnabled);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final LogConfig.Builder getLogConfig() {
            return this.logConfig != null ? this.logConfig.toBuilder() : null;
        }

        @Override
        public final Builder logConfig(LogConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        public final void setLogConfig(LogConfig.BuilderImpl logConfig) {
            this.logConfig = logConfig != null ? logConfig.build() : null;
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        public final UserPoolConfig.Builder getUserPoolConfig() {
            return this.userPoolConfig != null ? this.userPoolConfig.toBuilder() : null;
        }

        @Override
        public final Builder userPoolConfig(UserPoolConfig userPoolConfig) {
            this.userPoolConfig = userPoolConfig;
            return this;
        }

        public final void setUserPoolConfig(UserPoolConfig.BuilderImpl userPoolConfig) {
            this.userPoolConfig = userPoolConfig != null ? userPoolConfig.build() : null;
        }

        public final OpenIDConnectConfig.Builder getOpenIDConnectConfig() {
            return this.openIDConnectConfig != null ? this.openIDConnectConfig.toBuilder() : null;
        }

        @Override
        public final Builder openIDConnectConfig(OpenIDConnectConfig openIDConnectConfig) {
            this.openIDConnectConfig = openIDConnectConfig;
            return this;
        }

        public final void setOpenIDConnectConfig(OpenIDConnectConfig.BuilderImpl openIDConnectConfig) {
            this.openIDConnectConfig = openIDConnectConfig != null ? openIDConnectConfig.build() : null;
        }

        public final Collection<AdditionalAuthenticationProvider.Builder> getAdditionalAuthenticationProviders() {
            return this.additionalAuthenticationProviders != null ? (Collection)this.additionalAuthenticationProviders.stream().map(AdditionalAuthenticationProvider::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder additionalAuthenticationProviders(Collection<AdditionalAuthenticationProvider> additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders = AdditionalAuthenticationProvidersCopier.copy(additionalAuthenticationProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAuthenticationProviders(AdditionalAuthenticationProvider ... additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders(Arrays.asList(additionalAuthenticationProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAuthenticationProviders(Consumer<AdditionalAuthenticationProvider.Builder> ... additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders(Stream.of(additionalAuthenticationProviders).map(c -> (AdditionalAuthenticationProvider)((AdditionalAuthenticationProvider.Builder)AdditionalAuthenticationProvider.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdditionalAuthenticationProviders(Collection<AdditionalAuthenticationProvider.BuilderImpl> additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders = AdditionalAuthenticationProvidersCopier.copyFromBuilder(additionalAuthenticationProviders);
        }

        public final Boolean getXrayEnabled() {
            return this.xrayEnabled;
        }

        @Override
        public final Builder xrayEnabled(Boolean xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
            return this;
        }

        public final void setXrayEnabled(Boolean xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGraphqlApiRequest build() {
            return new UpdateGraphqlApiRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateGraphqlApiRequest> {
        public Builder apiId(String var1);

        public Builder name(String var1);

        public Builder logConfig(LogConfig var1);

        default public Builder logConfig(Consumer<LogConfig.Builder> logConfig) {
            return this.logConfig((LogConfig)((LogConfig.Builder)LogConfig.builder().applyMutation(logConfig)).build());
        }

        public Builder authenticationType(String var1);

        public Builder authenticationType(AuthenticationType var1);

        public Builder userPoolConfig(UserPoolConfig var1);

        default public Builder userPoolConfig(Consumer<UserPoolConfig.Builder> userPoolConfig) {
            return this.userPoolConfig((UserPoolConfig)((UserPoolConfig.Builder)UserPoolConfig.builder().applyMutation(userPoolConfig)).build());
        }

        public Builder openIDConnectConfig(OpenIDConnectConfig var1);

        default public Builder openIDConnectConfig(Consumer<OpenIDConnectConfig.Builder> openIDConnectConfig) {
            return this.openIDConnectConfig((OpenIDConnectConfig)((OpenIDConnectConfig.Builder)OpenIDConnectConfig.builder().applyMutation(openIDConnectConfig)).build());
        }

        public Builder additionalAuthenticationProviders(Collection<AdditionalAuthenticationProvider> var1);

        public Builder additionalAuthenticationProviders(AdditionalAuthenticationProvider ... var1);

        public Builder additionalAuthenticationProviders(Consumer<AdditionalAuthenticationProvider.Builder> ... var1);

        public Builder xrayEnabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

