/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIntrospectionSchemaRequest extends AppSyncRequest implements
        ToCopyableBuilder<GetIntrospectionSchemaRequest.Builder, GetIntrospectionSchemaRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetIntrospectionSchemaRequest::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetIntrospectionSchemaRequest::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("format").build()).build();

    private static final SdkField<Boolean> INCLUDE_DIRECTIVES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(GetIntrospectionSchemaRequest::includeDirectives)).setter(setter(Builder::includeDirectives))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeDirectives").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, FORMAT_FIELD,
            INCLUDE_DIRECTIVES_FIELD));

    private final String apiId;

    private final String format;

    private final Boolean includeDirectives;

    private GetIntrospectionSchemaRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.format = builder.format;
        this.includeDirectives = builder.includeDirectives;
    }

    /**
     * <p>
     * The API ID.
     * </p>
     * 
     * @return The API ID.
     */
    public String apiId() {
        return apiId;
    }

    /**
     * <p>
     * The schema format: SDL or JSON.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link OutputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The schema format: SDL or JSON.
     * @see OutputType
     */
    public OutputType format() {
        return OutputType.fromValue(format);
    }

    /**
     * <p>
     * The schema format: SDL or JSON.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link OutputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The schema format: SDL or JSON.
     * @see OutputType
     */
    public String formatAsString() {
        return format;
    }

    /**
     * <p>
     * A flag that specifies whether the schema introspection should contain directives.
     * </p>
     * 
     * @return A flag that specifies whether the schema introspection should contain directives.
     */
    public Boolean includeDirectives() {
        return includeDirectives;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(includeDirectives());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIntrospectionSchemaRequest)) {
            return false;
        }
        GetIntrospectionSchemaRequest other = (GetIntrospectionSchemaRequest) obj;
        return Objects.equals(apiId(), other.apiId()) && Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(includeDirectives(), other.includeDirectives());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetIntrospectionSchemaRequest").add("ApiId", apiId()).add("Format", formatAsString())
                .add("IncludeDirectives", includeDirectives()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "includeDirectives":
            return Optional.ofNullable(clazz.cast(includeDirectives()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIntrospectionSchemaRequest, T> g) {
        return obj -> g.apply((GetIntrospectionSchemaRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetIntrospectionSchemaRequest> {
        /**
         * <p>
         * The API ID.
         * </p>
         * 
         * @param apiId
         *        The API ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * The schema format: SDL or JSON.
         * </p>
         * 
         * @param format
         *        The schema format: SDL or JSON.
         * @see OutputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputType
         */
        Builder format(String format);

        /**
         * <p>
         * The schema format: SDL or JSON.
         * </p>
         * 
         * @param format
         *        The schema format: SDL or JSON.
         * @see OutputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputType
         */
        Builder format(OutputType format);

        /**
         * <p>
         * A flag that specifies whether the schema introspection should contain directives.
         * </p>
         * 
         * @param includeDirectives
         *        A flag that specifies whether the schema introspection should contain directives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeDirectives(Boolean includeDirectives);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppSyncRequest.BuilderImpl implements Builder {
        private String apiId;

        private String format;

        private Boolean includeDirectives;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIntrospectionSchemaRequest model) {
            super(model);
            apiId(model.apiId);
            format(model.format);
            includeDirectives(model.includeDirectives);
        }

        public final String getApiId() {
            return apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(OutputType format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final Boolean getIncludeDirectives() {
            return includeDirectives;
        }

        @Override
        public final Builder includeDirectives(Boolean includeDirectives) {
            this.includeDirectives = includeDirectives;
            return this;
        }

        public final void setIncludeDirectives(Boolean includeDirectives) {
            this.includeDirectives = includeDirectives;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetIntrospectionSchemaRequest build() {
            return new GetIntrospectionSchemaRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
