/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A function is a reusable entity. Multiple functions can be used to compose the resolver logic.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FunctionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FunctionConfiguration.Builder, FunctionConfiguration> {
    private static final SdkField<String> FUNCTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FunctionConfiguration::functionId)).setter(setter(Builder::functionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionId").build()).build();

    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FunctionConfiguration::functionArn)).setter(setter(Builder::functionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FunctionConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FunctionConfiguration::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DATA_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FunctionConfiguration::dataSourceName)).setter(setter(Builder::dataSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceName").build()).build();

    private static final SdkField<String> REQUEST_MAPPING_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FunctionConfiguration::requestMappingTemplate)).setter(setter(Builder::requestMappingTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestMappingTemplate").build())
            .build();

    private static final SdkField<String> RESPONSE_MAPPING_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FunctionConfiguration::responseMappingTemplate)).setter(setter(Builder::responseMappingTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseMappingTemplate").build())
            .build();

    private static final SdkField<String> FUNCTION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FunctionConfiguration::functionVersion)).setter(setter(Builder::functionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_ID_FIELD,
            FUNCTION_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, DATA_SOURCE_NAME_FIELD, REQUEST_MAPPING_TEMPLATE_FIELD,
            RESPONSE_MAPPING_TEMPLATE_FIELD, FUNCTION_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String functionId;

    private final String functionArn;

    private final String name;

    private final String description;

    private final String dataSourceName;

    private final String requestMappingTemplate;

    private final String responseMappingTemplate;

    private final String functionVersion;

    private FunctionConfiguration(BuilderImpl builder) {
        this.functionId = builder.functionId;
        this.functionArn = builder.functionArn;
        this.name = builder.name;
        this.description = builder.description;
        this.dataSourceName = builder.dataSourceName;
        this.requestMappingTemplate = builder.requestMappingTemplate;
        this.responseMappingTemplate = builder.responseMappingTemplate;
        this.functionVersion = builder.functionVersion;
    }

    /**
     * <p>
     * A unique ID representing the <code>Function</code> object.
     * </p>
     * 
     * @return A unique ID representing the <code>Function</code> object.
     */
    public String functionId() {
        return functionId;
    }

    /**
     * <p>
     * The ARN of the <code>Function</code> object.
     * </p>
     * 
     * @return The ARN of the <code>Function</code> object.
     */
    public String functionArn() {
        return functionArn;
    }

    /**
     * <p>
     * The name of the <code>Function</code> object.
     * </p>
     * 
     * @return The name of the <code>Function</code> object.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The <code>Function</code> description.
     * </p>
     * 
     * @return The <code>Function</code> description.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The name of the <code>DataSource</code>.
     * </p>
     * 
     * @return The name of the <code>DataSource</code>.
     */
    public String dataSourceName() {
        return dataSourceName;
    }

    /**
     * <p>
     * The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the request
     * mapping template.
     * </p>
     * 
     * @return The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the
     *         request mapping template.
     */
    public String requestMappingTemplate() {
        return requestMappingTemplate;
    }

    /**
     * <p>
     * The <code>Function</code> response mapping template.
     * </p>
     * 
     * @return The <code>Function</code> response mapping template.
     */
    public String responseMappingTemplate() {
        return responseMappingTemplate;
    }

    /**
     * <p>
     * The version of the request mapping template. Currently only the 2018-05-29 version of the template is supported.
     * </p>
     * 
     * @return The version of the request mapping template. Currently only the 2018-05-29 version of the template is
     *         supported.
     */
    public String functionVersion() {
        return functionVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(functionId());
        hashCode = 31 * hashCode + Objects.hashCode(functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(requestMappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(responseMappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(functionVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionConfiguration)) {
            return false;
        }
        FunctionConfiguration other = (FunctionConfiguration) obj;
        return Objects.equals(functionId(), other.functionId()) && Objects.equals(functionArn(), other.functionArn())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(dataSourceName(), other.dataSourceName())
                && Objects.equals(requestMappingTemplate(), other.requestMappingTemplate())
                && Objects.equals(responseMappingTemplate(), other.responseMappingTemplate())
                && Objects.equals(functionVersion(), other.functionVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FunctionConfiguration").add("FunctionId", functionId()).add("FunctionArn", functionArn())
                .add("Name", name()).add("Description", description()).add("DataSourceName", dataSourceName())
                .add("RequestMappingTemplate", requestMappingTemplate())
                .add("ResponseMappingTemplate", responseMappingTemplate()).add("FunctionVersion", functionVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "functionId":
            return Optional.ofNullable(clazz.cast(functionId()));
        case "functionArn":
            return Optional.ofNullable(clazz.cast(functionArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "dataSourceName":
            return Optional.ofNullable(clazz.cast(dataSourceName()));
        case "requestMappingTemplate":
            return Optional.ofNullable(clazz.cast(requestMappingTemplate()));
        case "responseMappingTemplate":
            return Optional.ofNullable(clazz.cast(responseMappingTemplate()));
        case "functionVersion":
            return Optional.ofNullable(clazz.cast(functionVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FunctionConfiguration, T> g) {
        return obj -> g.apply((FunctionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FunctionConfiguration> {
        /**
         * <p>
         * A unique ID representing the <code>Function</code> object.
         * </p>
         * 
         * @param functionId
         *        A unique ID representing the <code>Function</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionId(String functionId);

        /**
         * <p>
         * The ARN of the <code>Function</code> object.
         * </p>
         * 
         * @param functionArn
         *        The ARN of the <code>Function</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionArn(String functionArn);

        /**
         * <p>
         * The name of the <code>Function</code> object.
         * </p>
         * 
         * @param name
         *        The name of the <code>Function</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The <code>Function</code> description.
         * </p>
         * 
         * @param description
         *        The <code>Function</code> description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the <code>DataSource</code>.
         * </p>
         * 
         * @param dataSourceName
         *        The name of the <code>DataSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceName(String dataSourceName);

        /**
         * <p>
         * The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the
         * request mapping template.
         * </p>
         * 
         * @param requestMappingTemplate
         *        The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of
         *        the request mapping template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestMappingTemplate(String requestMappingTemplate);

        /**
         * <p>
         * The <code>Function</code> response mapping template.
         * </p>
         * 
         * @param responseMappingTemplate
         *        The <code>Function</code> response mapping template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseMappingTemplate(String responseMappingTemplate);

        /**
         * <p>
         * The version of the request mapping template. Currently only the 2018-05-29 version of the template is
         * supported.
         * </p>
         * 
         * @param functionVersion
         *        The version of the request mapping template. Currently only the 2018-05-29 version of the template is
         *        supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionVersion(String functionVersion);
    }

    static final class BuilderImpl implements Builder {
        private String functionId;

        private String functionArn;

        private String name;

        private String description;

        private String dataSourceName;

        private String requestMappingTemplate;

        private String responseMappingTemplate;

        private String functionVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionConfiguration model) {
            functionId(model.functionId);
            functionArn(model.functionArn);
            name(model.name);
            description(model.description);
            dataSourceName(model.dataSourceName);
            requestMappingTemplate(model.requestMappingTemplate);
            responseMappingTemplate(model.responseMappingTemplate);
            functionVersion(model.functionVersion);
        }

        public final String getFunctionId() {
            return functionId;
        }

        @Override
        public final Builder functionId(String functionId) {
            this.functionId = functionId;
            return this;
        }

        public final void setFunctionId(String functionId) {
            this.functionId = functionId;
        }

        public final String getFunctionArn() {
            return functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDataSourceName() {
            return dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        public final String getRequestMappingTemplate() {
            return requestMappingTemplate;
        }

        @Override
        public final Builder requestMappingTemplate(String requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
            return this;
        }

        public final void setRequestMappingTemplate(String requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
        }

        public final String getResponseMappingTemplate() {
            return responseMappingTemplate;
        }

        @Override
        public final Builder responseMappingTemplate(String responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
            return this;
        }

        public final void setResponseMappingTemplate(String responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
        }

        public final String getFunctionVersion() {
            return functionVersion;
        }

        @Override
        public final Builder functionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
            return this;
        }

        public final void setFunctionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
        }

        @Override
        public FunctionConfiguration build() {
            return new FunctionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
