/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApiKeyResponse extends AppSyncResponse implements
        ToCopyableBuilder<CreateApiKeyResponse.Builder, CreateApiKeyResponse> {
    private static final SdkField<ApiKey> API_KEY_FIELD = SdkField.<ApiKey> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateApiKeyResponse::apiKey)).setter(setter(Builder::apiKey)).constructor(ApiKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_KEY_FIELD));

    private final ApiKey apiKey;

    private CreateApiKeyResponse(BuilderImpl builder) {
        super(builder);
        this.apiKey = builder.apiKey;
    }

    /**
     * <p>
     * The API key.
     * </p>
     * 
     * @return The API key.
     */
    public ApiKey apiKey() {
        return apiKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiKey());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApiKeyResponse)) {
            return false;
        }
        CreateApiKeyResponse other = (CreateApiKeyResponse) obj;
        return Objects.equals(apiKey(), other.apiKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateApiKeyResponse").add("ApiKey", apiKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiKey":
            return Optional.ofNullable(clazz.cast(apiKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApiKeyResponse, T> g) {
        return obj -> g.apply((CreateApiKeyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateApiKeyResponse> {
        /**
         * <p>
         * The API key.
         * </p>
         * 
         * @param apiKey
         *        The API key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKey(ApiKey apiKey);

        /**
         * <p>
         * The API key.
         * </p>
         * This is a convenience that creates an instance of the {@link ApiKey.Builder} avoiding the need to create one
         * manually via {@link ApiKey#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApiKey.Builder#build()} is called immediately and its result is
         * passed to {@link #apiKey(ApiKey)}.
         * 
         * @param apiKey
         *        a consumer that will call methods on {@link ApiKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apiKey(ApiKey)
         */
        default Builder apiKey(Consumer<ApiKey.Builder> apiKey) {
            return apiKey(ApiKey.builder().applyMutation(apiKey).build());
        }
    }

    static final class BuilderImpl extends AppSyncResponse.BuilderImpl implements Builder {
        private ApiKey apiKey;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApiKeyResponse model) {
            super(model);
            apiKey(model.apiKey);
        }

        public final ApiKey.Builder getApiKey() {
            return apiKey != null ? apiKey.toBuilder() : null;
        }

        @Override
        public final Builder apiKey(ApiKey apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public final void setApiKey(ApiKey.BuilderImpl apiKey) {
            this.apiKey = apiKey != null ? apiKey.build() : null;
        }

        @Override
        public CreateApiKeyResponse build() {
            return new CreateApiKeyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
