/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTypesResponse extends AppSyncResponse implements
        ToCopyableBuilder<ListTypesResponse.Builder, ListTypesResponse> {
    private static final SdkField<List<Type>> TYPES_FIELD = SdkField
            .<List<Type>> builder(MarshallingType.LIST)
            .getter(getter(ListTypesResponse::types))
            .setter(setter(Builder::types))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("types").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Type> builder(MarshallingType.SDK_POJO)
                                            .constructor(Type::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTypesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TYPES_FIELD, NEXT_TOKEN_FIELD));

    private final List<Type> types;

    private final String nextToken;

    private ListTypesResponse(BuilderImpl builder) {
        super(builder);
        this.types = builder.types;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Types property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTypes() {
        return types != null && !(types instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <code>Type</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The <code>Type</code> objects.
     */
    public List<Type> types() {
        return types;
    }

    /**
     * <p>
     * An identifier to be passed in the next request to this operation to return the next set of items in the list.
     * </p>
     * 
     * @return An identifier to be passed in the next request to this operation to return the next set of items in the
     *         list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(types());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTypesResponse)) {
            return false;
        }
        ListTypesResponse other = (ListTypesResponse) obj;
        return Objects.equals(types(), other.types()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListTypesResponse").add("Types", types()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "types":
            return Optional.ofNullable(clazz.cast(types()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTypesResponse, T> g) {
        return obj -> g.apply((ListTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTypesResponse> {
        /**
         * <p>
         * The <code>Type</code> objects.
         * </p>
         * 
         * @param types
         *        The <code>Type</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(Collection<Type> types);

        /**
         * <p>
         * The <code>Type</code> objects.
         * </p>
         * 
         * @param types
         *        The <code>Type</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(Type... types);

        /**
         * <p>
         * The <code>Type</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Type>.Builder} avoiding the need to create
         * one manually via {@link List<Type>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Type>.Builder#build()} is called immediately and its result
         * is passed to {@link #types(List<Type>)}.
         * 
         * @param types
         *        a consumer that will call methods on {@link List<Type>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #types(List<Type>)
         */
        Builder types(Consumer<Type.Builder>... types);

        /**
         * <p>
         * An identifier to be passed in the next request to this operation to return the next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier to be passed in the next request to this operation to return the next set of items in
         *        the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppSyncResponse.BuilderImpl implements Builder {
        private List<Type> types = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTypesResponse model) {
            super(model);
            types(model.types);
            nextToken(model.nextToken);
        }

        public final Collection<Type.Builder> getTypes() {
            return types != null ? types.stream().map(Type::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder types(Collection<Type> types) {
            this.types = TypeListCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(Type... types) {
            types(Arrays.asList(types));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(Consumer<Type.Builder>... types) {
            types(Stream.of(types).map(c -> Type.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTypes(Collection<Type.BuilderImpl> types) {
            this.types = TypeListCopier.copyFromBuilder(types);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTypesResponse build() {
            return new ListTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
