/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSchemaCreationStatusResponse extends AppSyncResponse implements
        ToCopyableBuilder<GetSchemaCreationStatusResponse.Builder, GetSchemaCreationStatusResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSchemaCreationStatusResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSchemaCreationStatusResponse::details)).setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, DETAILS_FIELD));

    private final String status;

    private final String details;

    private GetSchemaCreationStatusResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.details = builder.details;
    }

    /**
     * <p>
     * The current state of the schema (PROCESSING, FAILED, SUCCESS, or NOT_APPLICABLE). When the schema is in the
     * ACTIVE state, you can add data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SchemaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the schema (PROCESSING, FAILED, SUCCESS, or NOT_APPLICABLE). When the schema is in
     *         the ACTIVE state, you can add data.
     * @see SchemaStatus
     */
    public SchemaStatus status() {
        return SchemaStatus.fromValue(status);
    }

    /**
     * <p>
     * The current state of the schema (PROCESSING, FAILED, SUCCESS, or NOT_APPLICABLE). When the schema is in the
     * ACTIVE state, you can add data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SchemaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the schema (PROCESSING, FAILED, SUCCESS, or NOT_APPLICABLE). When the schema is in
     *         the ACTIVE state, you can add data.
     * @see SchemaStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Detailed information about the status of the schema creation operation.
     * </p>
     * 
     * @return Detailed information about the status of the schema creation operation.
     */
    public String details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSchemaCreationStatusResponse)) {
            return false;
        }
        GetSchemaCreationStatusResponse other = (GetSchemaCreationStatusResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(details(), other.details());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetSchemaCreationStatusResponse").add("Status", statusAsString()).add("Details", details())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSchemaCreationStatusResponse, T> g) {
        return obj -> g.apply((GetSchemaCreationStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSchemaCreationStatusResponse> {
        /**
         * <p>
         * The current state of the schema (PROCESSING, FAILED, SUCCESS, or NOT_APPLICABLE). When the schema is in the
         * ACTIVE state, you can add data.
         * </p>
         * 
         * @param status
         *        The current state of the schema (PROCESSING, FAILED, SUCCESS, or NOT_APPLICABLE). When the schema is
         *        in the ACTIVE state, you can add data.
         * @see SchemaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current state of the schema (PROCESSING, FAILED, SUCCESS, or NOT_APPLICABLE). When the schema is in the
         * ACTIVE state, you can add data.
         * </p>
         * 
         * @param status
         *        The current state of the schema (PROCESSING, FAILED, SUCCESS, or NOT_APPLICABLE). When the schema is
         *        in the ACTIVE state, you can add data.
         * @see SchemaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaStatus
         */
        Builder status(SchemaStatus status);

        /**
         * <p>
         * Detailed information about the status of the schema creation operation.
         * </p>
         * 
         * @param details
         *        Detailed information about the status of the schema creation operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(String details);
    }

    static final class BuilderImpl extends AppSyncResponse.BuilderImpl implements Builder {
        private String status;

        private String details;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSchemaCreationStatusResponse model) {
            super(model);
            status(model.status);
            details(model.details);
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SchemaStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDetails() {
            return details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        @Override
        public GetSchemaCreationStatusResponse build() {
            return new GetSchemaCreationStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
