/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSource implements SdkPojo, Serializable, ToCopyableBuilder<DataSource.Builder, DataSource> {
    private static final SdkField<String> DATA_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataSource::dataSourceArn)).setter(setter(Builder::dataSourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataSource::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataSource::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataSource::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataSource::serviceRoleArn)).setter(setter(Builder::serviceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRoleArn").build()).build();

    private static final SdkField<DynamodbDataSourceConfig> DYNAMODB_CONFIG_FIELD = SdkField
            .<DynamodbDataSourceConfig> builder(MarshallingType.SDK_POJO).getter(getter(DataSource::dynamodbConfig))
            .setter(setter(Builder::dynamodbConfig)).constructor(DynamodbDataSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamodbConfig").build()).build();

    private static final SdkField<LambdaDataSourceConfig> LAMBDA_CONFIG_FIELD = SdkField
            .<LambdaDataSourceConfig> builder(MarshallingType.SDK_POJO).getter(getter(DataSource::lambdaConfig))
            .setter(setter(Builder::lambdaConfig)).constructor(LambdaDataSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaConfig").build()).build();

    private static final SdkField<ElasticsearchDataSourceConfig> ELASTICSEARCH_CONFIG_FIELD = SdkField
            .<ElasticsearchDataSourceConfig> builder(MarshallingType.SDK_POJO).getter(getter(DataSource::elasticsearchConfig))
            .setter(setter(Builder::elasticsearchConfig)).constructor(ElasticsearchDataSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elasticsearchConfig").build())
            .build();

    private static final SdkField<HttpDataSourceConfig> HTTP_CONFIG_FIELD = SdkField
            .<HttpDataSourceConfig> builder(MarshallingType.SDK_POJO).getter(getter(DataSource::httpConfig))
            .setter(setter(Builder::httpConfig)).constructor(HttpDataSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpConfig").build()).build();

    private static final SdkField<RelationalDatabaseDataSourceConfig> RELATIONAL_DATABASE_CONFIG_FIELD = SdkField
            .<RelationalDatabaseDataSourceConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(DataSource::relationalDatabaseConfig)).setter(setter(Builder::relationalDatabaseConfig))
            .constructor(RelationalDatabaseDataSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ARN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, SERVICE_ROLE_ARN_FIELD, DYNAMODB_CONFIG_FIELD, LAMBDA_CONFIG_FIELD,
            ELASTICSEARCH_CONFIG_FIELD, HTTP_CONFIG_FIELD, RELATIONAL_DATABASE_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataSourceArn;

    private final String name;

    private final String description;

    private final String type;

    private final String serviceRoleArn;

    private final DynamodbDataSourceConfig dynamodbConfig;

    private final LambdaDataSourceConfig lambdaConfig;

    private final ElasticsearchDataSourceConfig elasticsearchConfig;

    private final HttpDataSourceConfig httpConfig;

    private final RelationalDatabaseDataSourceConfig relationalDatabaseConfig;

    private DataSource(BuilderImpl builder) {
        this.dataSourceArn = builder.dataSourceArn;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.dynamodbConfig = builder.dynamodbConfig;
        this.lambdaConfig = builder.lambdaConfig;
        this.elasticsearchConfig = builder.elasticsearchConfig;
        this.httpConfig = builder.httpConfig;
        this.relationalDatabaseConfig = builder.relationalDatabaseConfig;
    }

    /**
     * <p>
     * The data source ARN.
     * </p>
     * 
     * @return The data source ARN.
     */
    public String dataSourceArn() {
        return dataSourceArn;
    }

    /**
     * <p>
     * The name of the data source.
     * </p>
     * 
     * @return The name of the data source.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the data source.
     * </p>
     * 
     * @return The description of the data source.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The type of the data source.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>AMAZON_DYNAMODB</b>: The data source is an Amazon DynamoDB table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AMAZON_ELASTICSEARCH</b>: The data source is an Amazon Elasticsearch Service domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AWS_LAMBDA</b>: The data source is an AWS Lambda function.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>NONE</b>: There is no data source. This type is used when you wish to invoke a GraphQL operation without
     * connecting to a data source, such as performing data transformation with resolvers or triggering a subscription
     * to be invoked from a mutation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>HTTP</b>: The data source is an HTTP endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>RELATIONAL_DATABASE</b>: The data source is a relational database.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the data source.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>AMAZON_DYNAMODB</b>: The data source is an Amazon DynamoDB table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AMAZON_ELASTICSEARCH</b>: The data source is an Amazon Elasticsearch Service domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AWS_LAMBDA</b>: The data source is an AWS Lambda function.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>NONE</b>: There is no data source. This type is used when you wish to invoke a GraphQL operation
     *         without connecting to a data source, such as performing data transformation with resolvers or triggering
     *         a subscription to be invoked from a mutation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>HTTP</b>: The data source is an HTTP endpoint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>RELATIONAL_DATABASE</b>: The data source is a relational database.
     *         </p>
     *         </li>
     * @see DataSourceType
     */
    public DataSourceType type() {
        return DataSourceType.fromValue(type);
    }

    /**
     * <p>
     * The type of the data source.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>AMAZON_DYNAMODB</b>: The data source is an Amazon DynamoDB table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AMAZON_ELASTICSEARCH</b>: The data source is an Amazon Elasticsearch Service domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AWS_LAMBDA</b>: The data source is an AWS Lambda function.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>NONE</b>: There is no data source. This type is used when you wish to invoke a GraphQL operation without
     * connecting to a data source, such as performing data transformation with resolvers or triggering a subscription
     * to be invoked from a mutation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>HTTP</b>: The data source is an HTTP endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>RELATIONAL_DATABASE</b>: The data source is a relational database.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the data source.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>AMAZON_DYNAMODB</b>: The data source is an Amazon DynamoDB table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AMAZON_ELASTICSEARCH</b>: The data source is an Amazon Elasticsearch Service domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AWS_LAMBDA</b>: The data source is an AWS Lambda function.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>NONE</b>: There is no data source. This type is used when you wish to invoke a GraphQL operation
     *         without connecting to a data source, such as performing data transformation with resolvers or triggering
     *         a subscription to be invoked from a mutation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>HTTP</b>: The data source is an HTTP endpoint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>RELATIONAL_DATABASE</b>: The data source is a relational database.
     *         </p>
     *         </li>
     * @see DataSourceType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The AWS IAM service role ARN for the data source. The system assumes this role when accessing the data source.
     * </p>
     * 
     * @return The AWS IAM service role ARN for the data source. The system assumes this role when accessing the data
     *         source.
     */
    public String serviceRoleArn() {
        return serviceRoleArn;
    }

    /**
     * <p>
     * Amazon DynamoDB settings.
     * </p>
     * 
     * @return Amazon DynamoDB settings.
     */
    public DynamodbDataSourceConfig dynamodbConfig() {
        return dynamodbConfig;
    }

    /**
     * <p>
     * AWS Lambda settings.
     * </p>
     * 
     * @return AWS Lambda settings.
     */
    public LambdaDataSourceConfig lambdaConfig() {
        return lambdaConfig;
    }

    /**
     * <p>
     * Amazon Elasticsearch Service settings.
     * </p>
     * 
     * @return Amazon Elasticsearch Service settings.
     */
    public ElasticsearchDataSourceConfig elasticsearchConfig() {
        return elasticsearchConfig;
    }

    /**
     * <p>
     * HTTP endpoint settings.
     * </p>
     * 
     * @return HTTP endpoint settings.
     */
    public HttpDataSourceConfig httpConfig() {
        return httpConfig;
    }

    /**
     * <p>
     * Relational database settings.
     * </p>
     * 
     * @return Relational database settings.
     */
    public RelationalDatabaseDataSourceConfig relationalDatabaseConfig() {
        return relationalDatabaseConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(dynamodbConfig());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(elasticsearchConfig());
        hashCode = 31 * hashCode + Objects.hashCode(httpConfig());
        hashCode = 31 * hashCode + Objects.hashCode(relationalDatabaseConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSource)) {
            return false;
        }
        DataSource other = (DataSource) obj;
        return Objects.equals(dataSourceArn(), other.dataSourceArn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(serviceRoleArn(), other.serviceRoleArn())
                && Objects.equals(dynamodbConfig(), other.dynamodbConfig())
                && Objects.equals(lambdaConfig(), other.lambdaConfig())
                && Objects.equals(elasticsearchConfig(), other.elasticsearchConfig())
                && Objects.equals(httpConfig(), other.httpConfig())
                && Objects.equals(relationalDatabaseConfig(), other.relationalDatabaseConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DataSource").add("DataSourceArn", dataSourceArn()).add("Name", name())
                .add("Description", description()).add("Type", typeAsString()).add("ServiceRoleArn", serviceRoleArn())
                .add("DynamodbConfig", dynamodbConfig()).add("LambdaConfig", lambdaConfig())
                .add("ElasticsearchConfig", elasticsearchConfig()).add("HttpConfig", httpConfig())
                .add("RelationalDatabaseConfig", relationalDatabaseConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSourceArn":
            return Optional.ofNullable(clazz.cast(dataSourceArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "serviceRoleArn":
            return Optional.ofNullable(clazz.cast(serviceRoleArn()));
        case "dynamodbConfig":
            return Optional.ofNullable(clazz.cast(dynamodbConfig()));
        case "lambdaConfig":
            return Optional.ofNullable(clazz.cast(lambdaConfig()));
        case "elasticsearchConfig":
            return Optional.ofNullable(clazz.cast(elasticsearchConfig()));
        case "httpConfig":
            return Optional.ofNullable(clazz.cast(httpConfig()));
        case "relationalDatabaseConfig":
            return Optional.ofNullable(clazz.cast(relationalDatabaseConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSource, T> g) {
        return obj -> g.apply((DataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSource> {
        /**
         * <p>
         * The data source ARN.
         * </p>
         * 
         * @param dataSourceArn
         *        The data source ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceArn(String dataSourceArn);

        /**
         * <p>
         * The name of the data source.
         * </p>
         * 
         * @param name
         *        The name of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the data source.
         * </p>
         * 
         * @param description
         *        The description of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of the data source.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>AMAZON_DYNAMODB</b>: The data source is an Amazon DynamoDB table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AMAZON_ELASTICSEARCH</b>: The data source is an Amazon Elasticsearch Service domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AWS_LAMBDA</b>: The data source is an AWS Lambda function.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>NONE</b>: There is no data source. This type is used when you wish to invoke a GraphQL operation without
         * connecting to a data source, such as performing data transformation with resolvers or triggering a
         * subscription to be invoked from a mutation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>HTTP</b>: The data source is an HTTP endpoint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>RELATIONAL_DATABASE</b>: The data source is a relational database.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of the data source.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>AMAZON_DYNAMODB</b>: The data source is an Amazon DynamoDB table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AMAZON_ELASTICSEARCH</b>: The data source is an Amazon Elasticsearch Service domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AWS_LAMBDA</b>: The data source is an AWS Lambda function.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>NONE</b>: There is no data source. This type is used when you wish to invoke a GraphQL operation
         *        without connecting to a data source, such as performing data transformation with resolvers or
         *        triggering a subscription to be invoked from a mutation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>HTTP</b>: The data source is an HTTP endpoint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>RELATIONAL_DATABASE</b>: The data source is a relational database.
         *        </p>
         *        </li>
         * @see DataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the data source.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>AMAZON_DYNAMODB</b>: The data source is an Amazon DynamoDB table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AMAZON_ELASTICSEARCH</b>: The data source is an Amazon Elasticsearch Service domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AWS_LAMBDA</b>: The data source is an AWS Lambda function.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>NONE</b>: There is no data source. This type is used when you wish to invoke a GraphQL operation without
         * connecting to a data source, such as performing data transformation with resolvers or triggering a
         * subscription to be invoked from a mutation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>HTTP</b>: The data source is an HTTP endpoint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>RELATIONAL_DATABASE</b>: The data source is a relational database.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of the data source.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>AMAZON_DYNAMODB</b>: The data source is an Amazon DynamoDB table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AMAZON_ELASTICSEARCH</b>: The data source is an Amazon Elasticsearch Service domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AWS_LAMBDA</b>: The data source is an AWS Lambda function.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>NONE</b>: There is no data source. This type is used when you wish to invoke a GraphQL operation
         *        without connecting to a data source, such as performing data transformation with resolvers or
         *        triggering a subscription to be invoked from a mutation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>HTTP</b>: The data source is an HTTP endpoint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>RELATIONAL_DATABASE</b>: The data source is a relational database.
         *        </p>
         *        </li>
         * @see DataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceType
         */
        Builder type(DataSourceType type);

        /**
         * <p>
         * The AWS IAM service role ARN for the data source. The system assumes this role when accessing the data
         * source.
         * </p>
         * 
         * @param serviceRoleArn
         *        The AWS IAM service role ARN for the data source. The system assumes this role when accessing the data
         *        source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleArn(String serviceRoleArn);

        /**
         * <p>
         * Amazon DynamoDB settings.
         * </p>
         * 
         * @param dynamodbConfig
         *        Amazon DynamoDB settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamodbConfig(DynamodbDataSourceConfig dynamodbConfig);

        /**
         * <p>
         * Amazon DynamoDB settings.
         * </p>
         * This is a convenience that creates an instance of the {@link DynamodbDataSourceConfig.Builder} avoiding the
         * need to create one manually via {@link DynamodbDataSourceConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DynamodbDataSourceConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #dynamodbConfig(DynamodbDataSourceConfig)}.
         * 
         * @param dynamodbConfig
         *        a consumer that will call methods on {@link DynamodbDataSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynamodbConfig(DynamodbDataSourceConfig)
         */
        default Builder dynamodbConfig(Consumer<DynamodbDataSourceConfig.Builder> dynamodbConfig) {
            return dynamodbConfig(DynamodbDataSourceConfig.builder().applyMutation(dynamodbConfig).build());
        }

        /**
         * <p>
         * AWS Lambda settings.
         * </p>
         * 
         * @param lambdaConfig
         *        AWS Lambda settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaConfig(LambdaDataSourceConfig lambdaConfig);

        /**
         * <p>
         * AWS Lambda settings.
         * </p>
         * This is a convenience that creates an instance of the {@link LambdaDataSourceConfig.Builder} avoiding the
         * need to create one manually via {@link LambdaDataSourceConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaDataSourceConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #lambdaConfig(LambdaDataSourceConfig)}.
         * 
         * @param lambdaConfig
         *        a consumer that will call methods on {@link LambdaDataSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaConfig(LambdaDataSourceConfig)
         */
        default Builder lambdaConfig(Consumer<LambdaDataSourceConfig.Builder> lambdaConfig) {
            return lambdaConfig(LambdaDataSourceConfig.builder().applyMutation(lambdaConfig).build());
        }

        /**
         * <p>
         * Amazon Elasticsearch Service settings.
         * </p>
         * 
         * @param elasticsearchConfig
         *        Amazon Elasticsearch Service settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchConfig(ElasticsearchDataSourceConfig elasticsearchConfig);

        /**
         * <p>
         * Amazon Elasticsearch Service settings.
         * </p>
         * This is a convenience that creates an instance of the {@link ElasticsearchDataSourceConfig.Builder} avoiding
         * the need to create one manually via {@link ElasticsearchDataSourceConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ElasticsearchDataSourceConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #elasticsearchConfig(ElasticsearchDataSourceConfig)}.
         * 
         * @param elasticsearchConfig
         *        a consumer that will call methods on {@link ElasticsearchDataSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticsearchConfig(ElasticsearchDataSourceConfig)
         */
        default Builder elasticsearchConfig(Consumer<ElasticsearchDataSourceConfig.Builder> elasticsearchConfig) {
            return elasticsearchConfig(ElasticsearchDataSourceConfig.builder().applyMutation(elasticsearchConfig).build());
        }

        /**
         * <p>
         * HTTP endpoint settings.
         * </p>
         * 
         * @param httpConfig
         *        HTTP endpoint settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpConfig(HttpDataSourceConfig httpConfig);

        /**
         * <p>
         * HTTP endpoint settings.
         * </p>
         * This is a convenience that creates an instance of the {@link HttpDataSourceConfig.Builder} avoiding the need
         * to create one manually via {@link HttpDataSourceConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HttpDataSourceConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #httpConfig(HttpDataSourceConfig)}.
         * 
         * @param httpConfig
         *        a consumer that will call methods on {@link HttpDataSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpConfig(HttpDataSourceConfig)
         */
        default Builder httpConfig(Consumer<HttpDataSourceConfig.Builder> httpConfig) {
            return httpConfig(HttpDataSourceConfig.builder().applyMutation(httpConfig).build());
        }

        /**
         * <p>
         * Relational database settings.
         * </p>
         * 
         * @param relationalDatabaseConfig
         *        Relational database settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabaseConfig(RelationalDatabaseDataSourceConfig relationalDatabaseConfig);

        /**
         * <p>
         * Relational database settings.
         * </p>
         * This is a convenience that creates an instance of the {@link RelationalDatabaseDataSourceConfig.Builder}
         * avoiding the need to create one manually via {@link RelationalDatabaseDataSourceConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link RelationalDatabaseDataSourceConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #relationalDatabaseConfig(RelationalDatabaseDataSourceConfig)}
         * .
         * 
         * @param relationalDatabaseConfig
         *        a consumer that will call methods on {@link RelationalDatabaseDataSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relationalDatabaseConfig(RelationalDatabaseDataSourceConfig)
         */
        default Builder relationalDatabaseConfig(Consumer<RelationalDatabaseDataSourceConfig.Builder> relationalDatabaseConfig) {
            return relationalDatabaseConfig(RelationalDatabaseDataSourceConfig.builder().applyMutation(relationalDatabaseConfig)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String dataSourceArn;

        private String name;

        private String description;

        private String type;

        private String serviceRoleArn;

        private DynamodbDataSourceConfig dynamodbConfig;

        private LambdaDataSourceConfig lambdaConfig;

        private ElasticsearchDataSourceConfig elasticsearchConfig;

        private HttpDataSourceConfig httpConfig;

        private RelationalDatabaseDataSourceConfig relationalDatabaseConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSource model) {
            dataSourceArn(model.dataSourceArn);
            name(model.name);
            description(model.description);
            type(model.type);
            serviceRoleArn(model.serviceRoleArn);
            dynamodbConfig(model.dynamodbConfig);
            lambdaConfig(model.lambdaConfig);
            elasticsearchConfig(model.elasticsearchConfig);
            httpConfig(model.httpConfig);
            relationalDatabaseConfig(model.relationalDatabaseConfig);
        }

        public final String getDataSourceArn() {
            return dataSourceArn;
        }

        @Override
        public final Builder dataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
            return this;
        }

        public final void setDataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataSourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getServiceRoleArn() {
            return serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final DynamodbDataSourceConfig.Builder getDynamodbConfig() {
            return dynamodbConfig != null ? dynamodbConfig.toBuilder() : null;
        }

        @Override
        public final Builder dynamodbConfig(DynamodbDataSourceConfig dynamodbConfig) {
            this.dynamodbConfig = dynamodbConfig;
            return this;
        }

        public final void setDynamodbConfig(DynamodbDataSourceConfig.BuilderImpl dynamodbConfig) {
            this.dynamodbConfig = dynamodbConfig != null ? dynamodbConfig.build() : null;
        }

        public final LambdaDataSourceConfig.Builder getLambdaConfig() {
            return lambdaConfig != null ? lambdaConfig.toBuilder() : null;
        }

        @Override
        public final Builder lambdaConfig(LambdaDataSourceConfig lambdaConfig) {
            this.lambdaConfig = lambdaConfig;
            return this;
        }

        public final void setLambdaConfig(LambdaDataSourceConfig.BuilderImpl lambdaConfig) {
            this.lambdaConfig = lambdaConfig != null ? lambdaConfig.build() : null;
        }

        public final ElasticsearchDataSourceConfig.Builder getElasticsearchConfig() {
            return elasticsearchConfig != null ? elasticsearchConfig.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchConfig(ElasticsearchDataSourceConfig elasticsearchConfig) {
            this.elasticsearchConfig = elasticsearchConfig;
            return this;
        }

        public final void setElasticsearchConfig(ElasticsearchDataSourceConfig.BuilderImpl elasticsearchConfig) {
            this.elasticsearchConfig = elasticsearchConfig != null ? elasticsearchConfig.build() : null;
        }

        public final HttpDataSourceConfig.Builder getHttpConfig() {
            return httpConfig != null ? httpConfig.toBuilder() : null;
        }

        @Override
        public final Builder httpConfig(HttpDataSourceConfig httpConfig) {
            this.httpConfig = httpConfig;
            return this;
        }

        public final void setHttpConfig(HttpDataSourceConfig.BuilderImpl httpConfig) {
            this.httpConfig = httpConfig != null ? httpConfig.build() : null;
        }

        public final RelationalDatabaseDataSourceConfig.Builder getRelationalDatabaseConfig() {
            return relationalDatabaseConfig != null ? relationalDatabaseConfig.toBuilder() : null;
        }

        @Override
        public final Builder relationalDatabaseConfig(RelationalDatabaseDataSourceConfig relationalDatabaseConfig) {
            this.relationalDatabaseConfig = relationalDatabaseConfig;
            return this;
        }

        public final void setRelationalDatabaseConfig(RelationalDatabaseDataSourceConfig.BuilderImpl relationalDatabaseConfig) {
            this.relationalDatabaseConfig = relationalDatabaseConfig != null ? relationalDatabaseConfig.build() : null;
        }

        @Override
        public DataSource build() {
            return new DataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
