/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.appsync.model.AppSyncRequest;
import software.amazon.awssdk.services.appsync.model.AuthenticationType;
import software.amazon.awssdk.services.appsync.model.UserPoolConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateGraphqlApiRequest
extends AppSyncRequest
implements ToCopyableBuilder<Builder, CreateGraphqlApiRequest> {
    private final String name;
    private final String authenticationType;
    private final UserPoolConfig userPoolConfig;

    private CreateGraphqlApiRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.authenticationType = builder.authenticationType;
        this.userPoolConfig = builder.userPoolConfig;
    }

    public String name() {
        return this.name;
    }

    public AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(this.authenticationType);
    }

    public String authenticationTypeString() {
        return this.authenticationType;
    }

    public UserPoolConfig userPoolConfig() {
        return this.userPoolConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGraphqlApiRequest)) {
            return false;
        }
        CreateGraphqlApiRequest other = (CreateGraphqlApiRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.authenticationTypeString(), other.authenticationTypeString()) && Objects.equals(this.userPoolConfig(), other.userPoolConfig());
    }

    public String toString() {
        return ToString.builder((String)"CreateGraphqlApiRequest").add("Name", (Object)this.name()).add("AuthenticationType", (Object)this.authenticationTypeString()).add("UserPoolConfig", (Object)this.userPoolConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "authenticationType": {
                return Optional.of(clazz.cast(this.authenticationTypeString()));
            }
            case "userPoolConfig": {
                return Optional.of(clazz.cast(this.userPoolConfig()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AppSyncRequest.BuilderImpl
    implements Builder {
        private String name;
        private String authenticationType;
        private UserPoolConfig userPoolConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGraphqlApiRequest model) {
            this.name(model.name);
            this.authenticationType(model.authenticationType);
            this.userPoolConfig(model.userPoolConfig);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType.toString());
            return this;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        public final UserPoolConfig.Builder getUserPoolConfig() {
            return this.userPoolConfig != null ? this.userPoolConfig.toBuilder() : null;
        }

        @Override
        public final Builder userPoolConfig(UserPoolConfig userPoolConfig) {
            this.userPoolConfig = userPoolConfig;
            return this;
        }

        public final void setUserPoolConfig(UserPoolConfig.BuilderImpl userPoolConfig) {
            this.userPoolConfig = userPoolConfig != null ? userPoolConfig.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateGraphqlApiRequest build() {
            return new CreateGraphqlApiRequest(this);
        }
    }

    public static interface Builder
    extends AppSyncRequest.Builder,
    CopyableBuilder<Builder, CreateGraphqlApiRequest> {
        public Builder name(String var1);

        public Builder authenticationType(String var1);

        public Builder authenticationType(AuthenticationType var1);

        public Builder userPoolConfig(UserPoolConfig var1);

        default public Builder userPoolConfig(Consumer<UserPoolConfig.Builder> userPoolConfig) {
            return this.userPoolConfig((UserPoolConfig)((UserPoolConfig.Builder)UserPoolConfig.builder().apply(userPoolConfig)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

