/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.ClientHandler;
import software.amazon.awssdk.core.client.SdkClientHandler;
import software.amazon.awssdk.core.config.ClientConfiguration;
import software.amazon.awssdk.core.config.SyncClientConfiguration;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.appsync.AppSyncClient;
import software.amazon.awssdk.services.appsync.model.ApiKeyLimitExceededException;
import software.amazon.awssdk.services.appsync.model.ApiLimitExceededException;
import software.amazon.awssdk.services.appsync.model.AppSyncException;
import software.amazon.awssdk.services.appsync.model.BadRequestException;
import software.amazon.awssdk.services.appsync.model.ConcurrentModificationException;
import software.amazon.awssdk.services.appsync.model.CreateApiKeyRequest;
import software.amazon.awssdk.services.appsync.model.CreateApiKeyResponse;
import software.amazon.awssdk.services.appsync.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.CreateGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.CreateGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.CreateResolverRequest;
import software.amazon.awssdk.services.appsync.model.CreateResolverResponse;
import software.amazon.awssdk.services.appsync.model.CreateTypeRequest;
import software.amazon.awssdk.services.appsync.model.CreateTypeResponse;
import software.amazon.awssdk.services.appsync.model.DeleteApiKeyRequest;
import software.amazon.awssdk.services.appsync.model.DeleteApiKeyResponse;
import software.amazon.awssdk.services.appsync.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.DeleteGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.DeleteGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.DeleteResolverRequest;
import software.amazon.awssdk.services.appsync.model.DeleteResolverResponse;
import software.amazon.awssdk.services.appsync.model.DeleteTypeRequest;
import software.amazon.awssdk.services.appsync.model.DeleteTypeResponse;
import software.amazon.awssdk.services.appsync.model.GetDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.GetDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.GetGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.GetGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaRequest;
import software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaResponse;
import software.amazon.awssdk.services.appsync.model.GetResolverRequest;
import software.amazon.awssdk.services.appsync.model.GetResolverResponse;
import software.amazon.awssdk.services.appsync.model.GetSchemaCreationStatusRequest;
import software.amazon.awssdk.services.appsync.model.GetSchemaCreationStatusResponse;
import software.amazon.awssdk.services.appsync.model.GetTypeRequest;
import software.amazon.awssdk.services.appsync.model.GetTypeResponse;
import software.amazon.awssdk.services.appsync.model.GraphQLSchemaException;
import software.amazon.awssdk.services.appsync.model.InternalFailureException;
import software.amazon.awssdk.services.appsync.model.LimitExceededException;
import software.amazon.awssdk.services.appsync.model.ListApiKeysRequest;
import software.amazon.awssdk.services.appsync.model.ListApiKeysResponse;
import software.amazon.awssdk.services.appsync.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.appsync.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.appsync.model.ListGraphqlApisRequest;
import software.amazon.awssdk.services.appsync.model.ListGraphqlApisResponse;
import software.amazon.awssdk.services.appsync.model.ListResolversRequest;
import software.amazon.awssdk.services.appsync.model.ListResolversResponse;
import software.amazon.awssdk.services.appsync.model.ListTypesRequest;
import software.amazon.awssdk.services.appsync.model.ListTypesResponse;
import software.amazon.awssdk.services.appsync.model.NotFoundException;
import software.amazon.awssdk.services.appsync.model.StartSchemaCreationRequest;
import software.amazon.awssdk.services.appsync.model.StartSchemaCreationResponse;
import software.amazon.awssdk.services.appsync.model.UnauthorizedException;
import software.amazon.awssdk.services.appsync.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.UpdateResolverRequest;
import software.amazon.awssdk.services.appsync.model.UpdateResolverResponse;
import software.amazon.awssdk.services.appsync.model.UpdateTypeRequest;
import software.amazon.awssdk.services.appsync.model.UpdateTypeResponse;
import software.amazon.awssdk.services.appsync.transform.CreateApiKeyRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateApiKeyResponseUnmarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateDataSourceResponseUnmarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateGraphqlApiResponseUnmarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateResolverRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateResolverResponseUnmarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateTypeRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateTypeResponseUnmarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteApiKeyRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteApiKeyResponseUnmarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteDataSourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteDataSourceResponseUnmarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteGraphqlApiResponseUnmarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteResolverRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteResolverResponseUnmarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteTypeRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteTypeResponseUnmarshaller;
import software.amazon.awssdk.services.appsync.transform.GetDataSourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetDataSourceResponseUnmarshaller;
import software.amazon.awssdk.services.appsync.transform.GetGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetGraphqlApiResponseUnmarshaller;
import software.amazon.awssdk.services.appsync.transform.GetIntrospectionSchemaRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetIntrospectionSchemaResponseUnmarshaller;
import software.amazon.awssdk.services.appsync.transform.GetResolverRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetResolverResponseUnmarshaller;
import software.amazon.awssdk.services.appsync.transform.GetSchemaCreationStatusRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetSchemaCreationStatusResponseUnmarshaller;
import software.amazon.awssdk.services.appsync.transform.GetTypeRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetTypeResponseUnmarshaller;
import software.amazon.awssdk.services.appsync.transform.ListApiKeysRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListApiKeysResponseUnmarshaller;
import software.amazon.awssdk.services.appsync.transform.ListDataSourcesRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListDataSourcesResponseUnmarshaller;
import software.amazon.awssdk.services.appsync.transform.ListGraphqlApisRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListGraphqlApisResponseUnmarshaller;
import software.amazon.awssdk.services.appsync.transform.ListResolversRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListResolversResponseUnmarshaller;
import software.amazon.awssdk.services.appsync.transform.ListTypesRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListTypesResponseUnmarshaller;
import software.amazon.awssdk.services.appsync.transform.StartSchemaCreationRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.StartSchemaCreationResponseUnmarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateDataSourceResponseUnmarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateGraphqlApiResponseUnmarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateResolverRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateResolverResponseUnmarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateTypeRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateTypeResponseUnmarshaller;

@SdkInternalApi
final class DefaultAppSyncClient
implements AppSyncClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final ClientConfiguration clientConfiguration;

    protected DefaultAppSyncClient(SyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    public final String serviceName() {
        return "appsync";
    }

    @Override
    public CreateApiKeyResponse createApiKey(CreateApiKeyRequest createApiKeyRequest) throws BadRequestException, NotFoundException, LimitExceededException, UnauthorizedException, InternalFailureException, ApiKeyLimitExceededException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateApiKeyResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateApiKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createApiKeyRequest).withMarshaller((Marshaller)new CreateApiKeyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateDataSourceResponse createDataSource(CreateDataSourceRequest createDataSourceRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDataSourceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDataSourceRequest).withMarshaller((Marshaller)new CreateDataSourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateGraphqlApiResponse createGraphqlApi(CreateGraphqlApiRequest createGraphqlApiRequest) throws BadRequestException, LimitExceededException, ConcurrentModificationException, UnauthorizedException, InternalFailureException, ApiLimitExceededException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateGraphqlApiResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateGraphqlApiResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGraphqlApiRequest).withMarshaller((Marshaller)new CreateGraphqlApiRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateResolverResponse createResolver(CreateResolverRequest createResolverRequest) throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateResolverResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateResolverResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createResolverRequest).withMarshaller((Marshaller)new CreateResolverRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateTypeResponse createType(CreateTypeRequest createTypeRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateTypeResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createTypeRequest).withMarshaller((Marshaller)new CreateTypeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteApiKeyResponse deleteApiKey(DeleteApiKeyRequest deleteApiKeyRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteApiKeyResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteApiKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteApiKeyRequest).withMarshaller((Marshaller)new DeleteApiKeyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteDataSourceResponse deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDataSourceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDataSourceRequest).withMarshaller((Marshaller)new DeleteDataSourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteGraphqlApiResponse deleteGraphqlApi(DeleteGraphqlApiRequest deleteGraphqlApiRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteGraphqlApiResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteGraphqlApiResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteGraphqlApiRequest).withMarshaller((Marshaller)new DeleteGraphqlApiRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteResolverResponse deleteResolver(DeleteResolverRequest deleteResolverRequest) throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteResolverResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteResolverResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteResolverRequest).withMarshaller((Marshaller)new DeleteResolverRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteTypeResponse deleteType(DeleteTypeRequest deleteTypeRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteTypeResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTypeRequest).withMarshaller((Marshaller)new DeleteTypeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetDataSourceResponse getDataSource(GetDataSourceRequest getDataSourceRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDataSourceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDataSourceRequest).withMarshaller((Marshaller)new GetDataSourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetGraphqlApiResponse getGraphqlApi(GetGraphqlApiRequest getGraphqlApiRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetGraphqlApiResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetGraphqlApiResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getGraphqlApiRequest).withMarshaller((Marshaller)new GetGraphqlApiRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetIntrospectionSchemaResponse getIntrospectionSchema(GetIntrospectionSchemaRequest getIntrospectionSchemaRequest) throws GraphQLSchemaException, NotFoundException, UnauthorizedException, InternalFailureException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetIntrospectionSchemaResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetIntrospectionSchemaResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getIntrospectionSchemaRequest).withMarshaller((Marshaller)new GetIntrospectionSchemaRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetResolverResponse getResolver(GetResolverRequest getResolverRequest) throws ConcurrentModificationException, NotFoundException, UnauthorizedException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetResolverResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetResolverResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getResolverRequest).withMarshaller((Marshaller)new GetResolverRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetSchemaCreationStatusResponse getSchemaCreationStatus(GetSchemaCreationStatusRequest getSchemaCreationStatusRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSchemaCreationStatusResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetSchemaCreationStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSchemaCreationStatusRequest).withMarshaller((Marshaller)new GetSchemaCreationStatusRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetTypeResponse getType(GetTypeRequest getTypeRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTypeResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTypeRequest).withMarshaller((Marshaller)new GetTypeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListApiKeysResponse listApiKeys(ListApiKeysRequest listApiKeysRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListApiKeysResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListApiKeysResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listApiKeysRequest).withMarshaller((Marshaller)new ListApiKeysRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListDataSourcesResponse listDataSources(ListDataSourcesRequest listDataSourcesRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDataSourcesResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListDataSourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDataSourcesRequest).withMarshaller((Marshaller)new ListDataSourcesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListGraphqlApisResponse listGraphqlApis(ListGraphqlApisRequest listGraphqlApisRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListGraphqlApisResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListGraphqlApisResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listGraphqlApisRequest).withMarshaller((Marshaller)new ListGraphqlApisRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListResolversResponse listResolvers(ListResolversRequest listResolversRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListResolversResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListResolversResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listResolversRequest).withMarshaller((Marshaller)new ListResolversRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListTypesResponse listTypes(ListTypesRequest listTypesRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTypesResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTypesRequest).withMarshaller((Marshaller)new ListTypesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StartSchemaCreationResponse startSchemaCreation(StartSchemaCreationRequest startSchemaCreationRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartSchemaCreationResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (StartSchemaCreationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startSchemaCreationRequest).withMarshaller((Marshaller)new StartSchemaCreationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateDataSourceResponse updateDataSource(UpdateDataSourceRequest updateDataSourceRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDataSourceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDataSourceRequest).withMarshaller((Marshaller)new UpdateDataSourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateGraphqlApiResponse updateGraphqlApi(UpdateGraphqlApiRequest updateGraphqlApiRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateGraphqlApiResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateGraphqlApiResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateGraphqlApiRequest).withMarshaller((Marshaller)new UpdateGraphqlApiRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateResolverResponse updateResolver(UpdateResolverRequest updateResolverRequest) throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateResolverResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateResolverResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateResolverRequest).withMarshaller((Marshaller)new UpdateResolverRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateTypeResponse updateType(UpdateTypeRequest updateTypeRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, SdkServiceException, SdkClientException, AppSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateTypeResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateTypeRequest).withMarshaller((Marshaller)new UpdateTypeRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<SdkServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(AppSyncException.class).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConcurrentModificationException").withModeledClass(ConcurrentModificationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalFailureException").withModeledClass(InternalFailureException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("GraphQLSchemaException").withModeledClass(GraphQLSchemaException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ApiLimitExceededException").withModeledClass(ApiLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(NotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedException").withModeledClass(UnauthorizedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ApiKeyLimitExceededException").withModeledClass(ApiKeyLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withModeledClass(BadRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)));
    }

    public void close() {
        this.clientHandler.close();
    }
}

