/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.appsync.model.Resolver;

public class ResolverUnmarshaller
implements Unmarshaller<Resolver, JsonUnmarshallerContext> {
    private static final ResolverUnmarshaller INSTANCE = new ResolverUnmarshaller();

    public Resolver unmarshall(JsonUnmarshallerContext context) throws Exception {
        Resolver.Builder resolverBuilder = Resolver.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("typeName", targetDepth)) {
                    context.nextToken();
                    resolverBuilder.typeName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("fieldName", targetDepth)) {
                    context.nextToken();
                    resolverBuilder.fieldName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("dataSourceName", targetDepth)) {
                    context.nextToken();
                    resolverBuilder.dataSourceName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("resolverArn", targetDepth)) {
                    context.nextToken();
                    resolverBuilder.resolverArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("requestMappingTemplate", targetDepth)) {
                    context.nextToken();
                    resolverBuilder.requestMappingTemplate((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("responseMappingTemplate", targetDepth)) {
                    context.nextToken();
                    resolverBuilder.responseMappingTemplate((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Resolver)resolverBuilder.build();
    }

    public static ResolverUnmarshaller getInstance() {
        return INSTANCE;
    }
}

