/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appsync.transform.DynamodbDataSourceConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DynamodbDataSourceConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, DynamodbDataSourceConfig> {
    private final String tableName;
    private final String awsRegion;
    private final Boolean useCallerCredentials;

    private DynamodbDataSourceConfig(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.awsRegion = builder.awsRegion;
        this.useCallerCredentials = builder.useCallerCredentials;
    }

    public String tableName() {
        return this.tableName;
    }

    public String awsRegion() {
        return this.awsRegion;
    }

    public Boolean useCallerCredentials() {
        return this.useCallerCredentials;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.useCallerCredentials());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamodbDataSourceConfig)) {
            return false;
        }
        DynamodbDataSourceConfig other = (DynamodbDataSourceConfig)obj;
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.awsRegion(), other.awsRegion()) && Objects.equals(this.useCallerCredentials(), other.useCallerCredentials());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.tableName() != null) {
            sb.append("TableName: ").append(this.tableName()).append(",");
        }
        if (this.awsRegion() != null) {
            sb.append("AwsRegion: ").append(this.awsRegion()).append(",");
        }
        if (this.useCallerCredentials() != null) {
            sb.append("UseCallerCredentials: ").append(this.useCallerCredentials()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tableName": {
                return Optional.of(clazz.cast(this.tableName()));
            }
            case "awsRegion": {
                return Optional.of(clazz.cast(this.awsRegion()));
            }
            case "useCallerCredentials": {
                return Optional.of(clazz.cast(this.useCallerCredentials()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DynamodbDataSourceConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String tableName;
        private String awsRegion;
        private Boolean useCallerCredentials;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamodbDataSourceConfig model) {
            this.tableName(model.tableName);
            this.awsRegion(model.awsRegion);
            this.useCallerCredentials(model.useCallerCredentials);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public final Boolean getUseCallerCredentials() {
            return this.useCallerCredentials;
        }

        @Override
        public final Builder useCallerCredentials(Boolean useCallerCredentials) {
            this.useCallerCredentials = useCallerCredentials;
            return this;
        }

        public final void setUseCallerCredentials(Boolean useCallerCredentials) {
            this.useCallerCredentials = useCallerCredentials;
        }

        public DynamodbDataSourceConfig build() {
            return new DynamodbDataSourceConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DynamodbDataSourceConfig> {
        public Builder tableName(String var1);

        public Builder awsRegion(String var1);

        public Builder useCallerCredentials(Boolean var1);
    }
}

