/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.appsync.model.LogConfig;

public class LogConfigUnmarshaller
implements Unmarshaller<LogConfig, JsonUnmarshallerContext> {
    private static final LogConfigUnmarshaller INSTANCE = new LogConfigUnmarshaller();

    public LogConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        LogConfig.Builder logConfigBuilder = LogConfig.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("fieldLogLevel", targetDepth)) {
                    context.nextToken();
                    logConfigBuilder.fieldLogLevel((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("cloudWatchLogsRoleArn", targetDepth)) {
                    context.nextToken();
                    logConfigBuilder.cloudWatchLogsRoleArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (LogConfig)logConfigBuilder.build();
    }

    public static LogConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}

