/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.appsync.model.AppSyncResponse;
import software.amazon.awssdk.services.appsync.model.GraphqlApi;
import software.amazon.awssdk.services.appsync.model.GraphqlApisCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListGraphqlApisResponse
extends AppSyncResponse
implements ToCopyableBuilder<Builder, ListGraphqlApisResponse> {
    private final List<GraphqlApi> graphqlApis;
    private final String nextToken;

    private ListGraphqlApisResponse(BuilderImpl builder) {
        super(builder);
        this.graphqlApis = builder.graphqlApis;
        this.nextToken = builder.nextToken;
    }

    public List<GraphqlApi> graphqlApis() {
        return this.graphqlApis;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.graphqlApis());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGraphqlApisResponse)) {
            return false;
        }
        ListGraphqlApisResponse other = (ListGraphqlApisResponse)((Object)obj);
        return Objects.equals(this.graphqlApis(), other.graphqlApis()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListGraphqlApisResponse").add("GraphqlApis", this.graphqlApis()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "graphqlApis": {
                return Optional.of(clazz.cast(this.graphqlApis()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AppSyncResponse.BuilderImpl
    implements Builder {
        private List<GraphqlApi> graphqlApis;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGraphqlApisResponse model) {
            super(model);
            this.graphqlApis(model.graphqlApis);
            this.nextToken(model.nextToken);
        }

        public final Collection<GraphqlApi.Builder> getGraphqlApis() {
            return this.graphqlApis != null ? (Collection)this.graphqlApis.stream().map(GraphqlApi::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder graphqlApis(Collection<GraphqlApi> graphqlApis) {
            this.graphqlApis = GraphqlApisCopier.copy(graphqlApis);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder graphqlApis(GraphqlApi ... graphqlApis) {
            this.graphqlApis(Arrays.asList(graphqlApis));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder graphqlApis(Consumer<GraphqlApi.Builder> ... graphqlApis) {
            this.graphqlApis(Stream.of(graphqlApis).map(c -> (GraphqlApi)((GraphqlApi.Builder)GraphqlApi.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGraphqlApis(Collection<GraphqlApi.BuilderImpl> graphqlApis) {
            this.graphqlApis = GraphqlApisCopier.copyFromBuilder(graphqlApis);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListGraphqlApisResponse build() {
            return new ListGraphqlApisResponse(this);
        }
    }

    public static interface Builder
    extends AppSyncResponse.Builder,
    CopyableBuilder<Builder, ListGraphqlApisResponse> {
        public Builder graphqlApis(Collection<GraphqlApi> var1);

        public Builder graphqlApis(GraphqlApi ... var1);

        public Builder graphqlApis(Consumer<GraphqlApi.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

