/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImageStateChangeReasonCode {
    INTERNAL_ERROR("INTERNAL_ERROR"),
    IMAGE_BUILDER_NOT_AVAILABLE("IMAGE_BUILDER_NOT_AVAILABLE"),
    IMAGE_COPY_FAILURE("IMAGE_COPY_FAILURE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImageStateChangeReasonCode> VALUE_MAP;
    private final String value;

    private ImageStateChangeReasonCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImageStateChangeReasonCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImageStateChangeReasonCode> knownValues() {
        EnumSet<ImageStateChangeReasonCode> knownValues = EnumSet.allOf(ImageStateChangeReasonCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImageStateChangeReasonCode.class, ImageStateChangeReasonCode::toString);
    }
}

