/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appstream.model.AppStreamResponse;
import software.amazon.awssdk.services.appstream.model.Image;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateUpdatedImageResponse
extends AppStreamResponse
implements ToCopyableBuilder<Builder, CreateUpdatedImageResponse> {
    private static final SdkField<Image> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("image").getter(CreateUpdatedImageResponse.getter(CreateUpdatedImageResponse::image)).setter(CreateUpdatedImageResponse.setter(Builder::image)).constructor(Image::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()}).build();
    private static final SdkField<Boolean> CAN_UPDATE_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("canUpdateImage").getter(CreateUpdatedImageResponse.getter(CreateUpdatedImageResponse::canUpdateImage)).setter(CreateUpdatedImageResponse.setter(Builder::canUpdateImage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canUpdateImage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_FIELD, CAN_UPDATE_IMAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("image", IMAGE_FIELD);
            this.put("canUpdateImage", CAN_UPDATE_IMAGE_FIELD);
        }
    });
    private final Image image;
    private final Boolean canUpdateImage;

    private CreateUpdatedImageResponse(BuilderImpl builder) {
        super(builder);
        this.image = builder.image;
        this.canUpdateImage = builder.canUpdateImage;
    }

    public final Image image() {
        return this.image;
    }

    public final Boolean canUpdateImage() {
        return this.canUpdateImage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.canUpdateImage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUpdatedImageResponse)) {
            return false;
        }
        CreateUpdatedImageResponse other = (CreateUpdatedImageResponse)((Object)obj);
        return Objects.equals(this.image(), other.image()) && Objects.equals(this.canUpdateImage(), other.canUpdateImage());
    }

    public final String toString() {
        return ToString.builder((String)"CreateUpdatedImageResponse").add("Image", (Object)this.image()).add("CanUpdateImage", (Object)this.canUpdateImage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "canUpdateImage": {
                return Optional.ofNullable(clazz.cast(this.canUpdateImage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateUpdatedImageResponse, T> g) {
        return obj -> g.apply((CreateUpdatedImageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamResponse.BuilderImpl
    implements Builder {
        private Image image;
        private Boolean canUpdateImage;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUpdatedImageResponse model) {
            super(model);
            this.image(model.image);
            this.canUpdateImage(model.canUpdateImage);
        }

        public final Image.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final Boolean getCanUpdateImage() {
            return this.canUpdateImage;
        }

        public final void setCanUpdateImage(Boolean canUpdateImage) {
            this.canUpdateImage = canUpdateImage;
        }

        @Override
        public final Builder canUpdateImage(Boolean canUpdateImage) {
            this.canUpdateImage = canUpdateImage;
            return this;
        }

        @Override
        public CreateUpdatedImageResponse build() {
            return new CreateUpdatedImageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppStreamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateUpdatedImageResponse> {
        public Builder image(Image var1);

        default public Builder image(Consumer<Image.Builder> image) {
            return this.image((Image)((Image.Builder)Image.builder().applyMutation(image)).build());
        }

        public Builder canUpdateImage(Boolean var1);
    }
}

