/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.appstream.AppStreamClient;
import software.amazon.awssdk.services.appstream.AppStreamClientBuilder;
import software.amazon.awssdk.services.appstream.AppStreamServiceClientConfiguration;
import software.amazon.awssdk.services.appstream.DefaultAppStreamBaseClientBuilder;
import software.amazon.awssdk.services.appstream.DefaultAppStreamClient;
import software.amazon.awssdk.services.appstream.endpoints.AppStreamEndpointProvider;

@SdkInternalApi
final class DefaultAppStreamClientBuilder
extends DefaultAppStreamBaseClientBuilder<AppStreamClientBuilder, AppStreamClient>
implements AppStreamClientBuilder {
    DefaultAppStreamClientBuilder() {
    }

    @Override
    public DefaultAppStreamClientBuilder endpointProvider(AppStreamEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AppStreamClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultAppStreamClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        AppStreamServiceClientConfiguration serviceClientConfiguration = AppStreamServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultAppStreamClient(serviceClientConfiguration, clientConfiguration);
    }
}

