/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AppStreamResponse;
import software.amazon.awssdk.services.appstream.model.UserStackAssociation;
import software.amazon.awssdk.services.appstream.model.UserStackAssociationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeUserStackAssociationsResponse
extends AppStreamResponse
implements ToCopyableBuilder<Builder, DescribeUserStackAssociationsResponse> {
    private static final SdkField<List<UserStackAssociation>> USER_STACK_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserStackAssociations").getter(DescribeUserStackAssociationsResponse.getter(DescribeUserStackAssociationsResponse::userStackAssociations)).setter(DescribeUserStackAssociationsResponse.setter(Builder::userStackAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserStackAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserStackAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeUserStackAssociationsResponse.getter(DescribeUserStackAssociationsResponse::nextToken)).setter(DescribeUserStackAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_STACK_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<UserStackAssociation> userStackAssociations;
    private final String nextToken;

    private DescribeUserStackAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.userStackAssociations = builder.userStackAssociations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasUserStackAssociations() {
        return this.userStackAssociations != null && !(this.userStackAssociations instanceof SdkAutoConstructList);
    }

    public final List<UserStackAssociation> userStackAssociations() {
        return this.userStackAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserStackAssociations() ? this.userStackAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserStackAssociationsResponse)) {
            return false;
        }
        DescribeUserStackAssociationsResponse other = (DescribeUserStackAssociationsResponse)((Object)obj);
        return this.hasUserStackAssociations() == other.hasUserStackAssociations() && Objects.equals(this.userStackAssociations(), other.userStackAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeUserStackAssociationsResponse").add("UserStackAssociations", this.hasUserStackAssociations() ? this.userStackAssociations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserStackAssociations": {
                return Optional.ofNullable(clazz.cast(this.userStackAssociations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserStackAssociationsResponse, T> g) {
        return obj -> g.apply((DescribeUserStackAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamResponse.BuilderImpl
    implements Builder {
        private List<UserStackAssociation> userStackAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserStackAssociationsResponse model) {
            super(model);
            this.userStackAssociations(model.userStackAssociations);
            this.nextToken(model.nextToken);
        }

        public final List<UserStackAssociation.Builder> getUserStackAssociations() {
            List<UserStackAssociation.Builder> result = UserStackAssociationListCopier.copyToBuilder(this.userStackAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserStackAssociations(Collection<UserStackAssociation.BuilderImpl> userStackAssociations) {
            this.userStackAssociations = UserStackAssociationListCopier.copyFromBuilder(userStackAssociations);
        }

        @Override
        public final Builder userStackAssociations(Collection<UserStackAssociation> userStackAssociations) {
            this.userStackAssociations = UserStackAssociationListCopier.copy(userStackAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userStackAssociations(UserStackAssociation ... userStackAssociations) {
            this.userStackAssociations(Arrays.asList(userStackAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userStackAssociations(Consumer<UserStackAssociation.Builder> ... userStackAssociations) {
            this.userStackAssociations(Stream.of(userStackAssociations).map(c -> (UserStackAssociation)((UserStackAssociation.Builder)UserStackAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeUserStackAssociationsResponse build() {
            return new DescribeUserStackAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppStreamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeUserStackAssociationsResponse> {
        public Builder userStackAssociations(Collection<UserStackAssociation> var1);

        public Builder userStackAssociations(UserStackAssociation ... var1);

        public Builder userStackAssociations(Consumer<UserStackAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

