/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StackErrorCode {
    STORAGE_CONNECTOR_ERROR("STORAGE_CONNECTOR_ERROR"),
    INTERNAL_SERVICE_ERROR("INTERNAL_SERVICE_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StackErrorCode> VALUE_MAP;
    private final String value;

    private StackErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StackErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StackErrorCode> knownValues() {
        EnumSet<StackErrorCode> knownValues = EnumSet.allOf(StackErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StackErrorCode.class, StackErrorCode::toString);
    }
}

