/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appstream.model.AccessEndpoint;
import software.amazon.awssdk.services.appstream.model.AccessEndpointListCopier;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.DomainJoinInfo;
import software.amazon.awssdk.services.appstream.model.TagsCopier;
import software.amazon.awssdk.services.appstream.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateImageBuilderRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, CreateImageBuilderRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateImageBuilderRequest.getter(CreateImageBuilderRequest::name)).setter(CreateImageBuilderRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageName").getter(CreateImageBuilderRequest.getter(CreateImageBuilderRequest::imageName)).setter(CreateImageBuilderRequest.setter(Builder::imageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()}).build();
    private static final SdkField<String> IMAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageArn").getter(CreateImageBuilderRequest.getter(CreateImageBuilderRequest::imageArn)).setter(CreateImageBuilderRequest.setter(Builder::imageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageArn").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(CreateImageBuilderRequest.getter(CreateImageBuilderRequest::instanceType)).setter(CreateImageBuilderRequest.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateImageBuilderRequest.getter(CreateImageBuilderRequest::description)).setter(CreateImageBuilderRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(CreateImageBuilderRequest.getter(CreateImageBuilderRequest::displayName)).setter(CreateImageBuilderRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(CreateImageBuilderRequest.getter(CreateImageBuilderRequest::vpcConfig)).setter(CreateImageBuilderRequest.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(CreateImageBuilderRequest.getter(CreateImageBuilderRequest::iamRoleArn)).setter(CreateImageBuilderRequest.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<Boolean> ENABLE_DEFAULT_INTERNET_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableDefaultInternetAccess").getter(CreateImageBuilderRequest.getter(CreateImageBuilderRequest::enableDefaultInternetAccess)).setter(CreateImageBuilderRequest.setter(Builder::enableDefaultInternetAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDefaultInternetAccess").build()}).build();
    private static final SdkField<DomainJoinInfo> DOMAIN_JOIN_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DomainJoinInfo").getter(CreateImageBuilderRequest.getter(CreateImageBuilderRequest::domainJoinInfo)).setter(CreateImageBuilderRequest.setter(Builder::domainJoinInfo)).constructor(DomainJoinInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainJoinInfo").build()}).build();
    private static final SdkField<String> APPSTREAM_AGENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppstreamAgentVersion").getter(CreateImageBuilderRequest.getter(CreateImageBuilderRequest::appstreamAgentVersion)).setter(CreateImageBuilderRequest.setter(Builder::appstreamAgentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppstreamAgentVersion").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateImageBuilderRequest.getter(CreateImageBuilderRequest::tags)).setter(CreateImageBuilderRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<AccessEndpoint>> ACCESS_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessEndpoints").getter(CreateImageBuilderRequest.getter(CreateImageBuilderRequest::accessEndpoints)).setter(CreateImageBuilderRequest.setter(Builder::accessEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, IMAGE_NAME_FIELD, IMAGE_ARN_FIELD, INSTANCE_TYPE_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, VPC_CONFIG_FIELD, IAM_ROLE_ARN_FIELD, ENABLE_DEFAULT_INTERNET_ACCESS_FIELD, DOMAIN_JOIN_INFO_FIELD, APPSTREAM_AGENT_VERSION_FIELD, TAGS_FIELD, ACCESS_ENDPOINTS_FIELD));
    private final String name;
    private final String imageName;
    private final String imageArn;
    private final String instanceType;
    private final String description;
    private final String displayName;
    private final VpcConfig vpcConfig;
    private final String iamRoleArn;
    private final Boolean enableDefaultInternetAccess;
    private final DomainJoinInfo domainJoinInfo;
    private final String appstreamAgentVersion;
    private final Map<String, String> tags;
    private final List<AccessEndpoint> accessEndpoints;

    private CreateImageBuilderRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.imageName = builder.imageName;
        this.imageArn = builder.imageArn;
        this.instanceType = builder.instanceType;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.vpcConfig = builder.vpcConfig;
        this.iamRoleArn = builder.iamRoleArn;
        this.enableDefaultInternetAccess = builder.enableDefaultInternetAccess;
        this.domainJoinInfo = builder.domainJoinInfo;
        this.appstreamAgentVersion = builder.appstreamAgentVersion;
        this.tags = builder.tags;
        this.accessEndpoints = builder.accessEndpoints;
    }

    public String name() {
        return this.name;
    }

    public String imageName() {
        return this.imageName;
    }

    public String imageArn() {
        return this.imageArn;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String description() {
        return this.description;
    }

    public String displayName() {
        return this.displayName;
    }

    public VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public String iamRoleArn() {
        return this.iamRoleArn;
    }

    public Boolean enableDefaultInternetAccess() {
        return this.enableDefaultInternetAccess;
    }

    public DomainJoinInfo domainJoinInfo() {
        return this.domainJoinInfo;
    }

    public String appstreamAgentVersion() {
        return this.appstreamAgentVersion;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public boolean hasAccessEndpoints() {
        return this.accessEndpoints != null && !(this.accessEndpoints instanceof SdkAutoConstructList);
    }

    public List<AccessEndpoint> accessEndpoints() {
        return this.accessEndpoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDefaultInternetAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainJoinInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.appstreamAgentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessEndpoints());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImageBuilderRequest)) {
            return false;
        }
        CreateImageBuilderRequest other = (CreateImageBuilderRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.imageName(), other.imageName()) && Objects.equals(this.imageArn(), other.imageArn()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.enableDefaultInternetAccess(), other.enableDefaultInternetAccess()) && Objects.equals(this.domainJoinInfo(), other.domainJoinInfo()) && Objects.equals(this.appstreamAgentVersion(), other.appstreamAgentVersion()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.accessEndpoints(), other.accessEndpoints());
    }

    public String toString() {
        return ToString.builder((String)"CreateImageBuilderRequest").add("Name", (Object)this.name()).add("ImageName", (Object)this.imageName()).add("ImageArn", (Object)this.imageArn()).add("InstanceType", (Object)this.instanceType()).add("Description", (Object)this.description()).add("DisplayName", (Object)this.displayName()).add("VpcConfig", (Object)this.vpcConfig()).add("IamRoleArn", (Object)this.iamRoleArn()).add("EnableDefaultInternetAccess", (Object)this.enableDefaultInternetAccess()).add("DomainJoinInfo", (Object)this.domainJoinInfo()).add("AppstreamAgentVersion", (Object)this.appstreamAgentVersion()).add("Tags", this.tags()).add("AccessEndpoints", this.accessEndpoints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ImageName": {
                return Optional.ofNullable(clazz.cast(this.imageName()));
            }
            case "ImageArn": {
                return Optional.ofNullable(clazz.cast(this.imageArn()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "EnableDefaultInternetAccess": {
                return Optional.ofNullable(clazz.cast(this.enableDefaultInternetAccess()));
            }
            case "DomainJoinInfo": {
                return Optional.ofNullable(clazz.cast(this.domainJoinInfo()));
            }
            case "AppstreamAgentVersion": {
                return Optional.ofNullable(clazz.cast(this.appstreamAgentVersion()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "AccessEndpoints": {
                return Optional.ofNullable(clazz.cast(this.accessEndpoints()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateImageBuilderRequest, T> g) {
        return obj -> g.apply((CreateImageBuilderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String name;
        private String imageName;
        private String imageArn;
        private String instanceType;
        private String description;
        private String displayName;
        private VpcConfig vpcConfig;
        private String iamRoleArn;
        private Boolean enableDefaultInternetAccess;
        private DomainJoinInfo domainJoinInfo;
        private String appstreamAgentVersion;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<AccessEndpoint> accessEndpoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImageBuilderRequest model) {
            super(model);
            this.name(model.name);
            this.imageName(model.imageName);
            this.imageArn(model.imageArn);
            this.instanceType(model.instanceType);
            this.description(model.description);
            this.displayName(model.displayName);
            this.vpcConfig(model.vpcConfig);
            this.iamRoleArn(model.iamRoleArn);
            this.enableDefaultInternetAccess(model.enableDefaultInternetAccess);
            this.domainJoinInfo(model.domainJoinInfo);
            this.appstreamAgentVersion(model.appstreamAgentVersion);
            this.tags(model.tags);
            this.accessEndpoints(model.accessEndpoints);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getImageName() {
            return this.imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public final String getImageArn() {
            return this.imageArn;
        }

        @Override
        public final Builder imageArn(String imageArn) {
            this.imageArn = imageArn;
            return this;
        }

        public final void setImageArn(String imageArn) {
            this.imageArn = imageArn;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final Boolean getEnableDefaultInternetAccess() {
            return this.enableDefaultInternetAccess;
        }

        @Override
        public final Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
            return this;
        }

        public final void setEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
        }

        public final DomainJoinInfo.Builder getDomainJoinInfo() {
            return this.domainJoinInfo != null ? this.domainJoinInfo.toBuilder() : null;
        }

        @Override
        public final Builder domainJoinInfo(DomainJoinInfo domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo;
            return this;
        }

        public final void setDomainJoinInfo(DomainJoinInfo.BuilderImpl domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo != null ? domainJoinInfo.build() : null;
        }

        public final String getAppstreamAgentVersion() {
            return this.appstreamAgentVersion;
        }

        @Override
        public final Builder appstreamAgentVersion(String appstreamAgentVersion) {
            this.appstreamAgentVersion = appstreamAgentVersion;
            return this;
        }

        public final void setAppstreamAgentVersion(String appstreamAgentVersion) {
            this.appstreamAgentVersion = appstreamAgentVersion;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final Collection<AccessEndpoint.Builder> getAccessEndpoints() {
            return this.accessEndpoints != null ? (Collection)this.accessEndpoints.stream().map(AccessEndpoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accessEndpoints(Collection<AccessEndpoint> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copy(accessEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(AccessEndpoint ... accessEndpoints) {
            this.accessEndpoints(Arrays.asList(accessEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(Consumer<AccessEndpoint.Builder> ... accessEndpoints) {
            this.accessEndpoints(Stream.of(accessEndpoints).map(c -> (AccessEndpoint)((AccessEndpoint.Builder)AccessEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccessEndpoints(Collection<AccessEndpoint.BuilderImpl> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copyFromBuilder(accessEndpoints);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateImageBuilderRequest build() {
            return new CreateImageBuilderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppStreamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateImageBuilderRequest> {
        public Builder name(String var1);

        public Builder imageName(String var1);

        public Builder imageArn(String var1);

        public Builder instanceType(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder iamRoleArn(String var1);

        public Builder enableDefaultInternetAccess(Boolean var1);

        public Builder domainJoinInfo(DomainJoinInfo var1);

        default public Builder domainJoinInfo(Consumer<DomainJoinInfo.Builder> domainJoinInfo) {
            return this.domainJoinInfo((DomainJoinInfo)((DomainJoinInfo.Builder)DomainJoinInfo.builder().applyMutation(domainJoinInfo)).build());
        }

        public Builder appstreamAgentVersion(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder accessEndpoints(Collection<AccessEndpoint> var1);

        public Builder accessEndpoints(AccessEndpoint ... var1);

        public Builder accessEndpoints(Consumer<AccessEndpoint.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

