/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AccessEndpoint;
import software.amazon.awssdk.services.appstream.model.AccessEndpointListCopier;
import software.amazon.awssdk.services.appstream.model.DomainJoinInfo;
import software.amazon.awssdk.services.appstream.model.ImageBuilderState;
import software.amazon.awssdk.services.appstream.model.ImageBuilderStateChangeReason;
import software.amazon.awssdk.services.appstream.model.NetworkAccessConfiguration;
import software.amazon.awssdk.services.appstream.model.PlatformType;
import software.amazon.awssdk.services.appstream.model.ResourceError;
import software.amazon.awssdk.services.appstream.model.ResourceErrorsCopier;
import software.amazon.awssdk.services.appstream.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageBuilder
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageBuilder> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImageBuilder.getter(ImageBuilder::name)).setter(ImageBuilder.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImageBuilder.getter(ImageBuilder::arn)).setter(ImageBuilder.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> IMAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImageBuilder.getter(ImageBuilder::imageArn)).setter(ImageBuilder.setter(Builder::imageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImageBuilder.getter(ImageBuilder::description)).setter(ImageBuilder.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImageBuilder.getter(ImageBuilder::displayName)).setter(ImageBuilder.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ImageBuilder.getter(ImageBuilder::vpcConfig)).setter(ImageBuilder.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImageBuilder.getter(ImageBuilder::instanceType)).setter(ImageBuilder.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImageBuilder.getter(ImageBuilder::platformAsString)).setter(ImageBuilder.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImageBuilder.getter(ImageBuilder::iamRoleArn)).setter(ImageBuilder.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImageBuilder.getter(ImageBuilder::stateAsString)).setter(ImageBuilder.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<ImageBuilderStateChangeReason> STATE_CHANGE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ImageBuilder.getter(ImageBuilder::stateChangeReason)).setter(ImageBuilder.setter(Builder::stateChangeReason)).constructor(ImageBuilderStateChangeReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateChangeReason").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ImageBuilder.getter(ImageBuilder::createdTime)).setter(ImageBuilder.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Boolean> ENABLE_DEFAULT_INTERNET_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ImageBuilder.getter(ImageBuilder::enableDefaultInternetAccess)).setter(ImageBuilder.setter(Builder::enableDefaultInternetAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDefaultInternetAccess").build()}).build();
    private static final SdkField<DomainJoinInfo> DOMAIN_JOIN_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ImageBuilder.getter(ImageBuilder::domainJoinInfo)).setter(ImageBuilder.setter(Builder::domainJoinInfo)).constructor(DomainJoinInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainJoinInfo").build()}).build();
    private static final SdkField<NetworkAccessConfiguration> NETWORK_ACCESS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ImageBuilder.getter(ImageBuilder::networkAccessConfiguration)).setter(ImageBuilder.setter(Builder::networkAccessConfiguration)).constructor(NetworkAccessConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAccessConfiguration").build()}).build();
    private static final SdkField<List<ResourceError>> IMAGE_BUILDER_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ImageBuilder.getter(ImageBuilder::imageBuilderErrors)).setter(ImageBuilder.setter(Builder::imageBuilderErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageBuilderErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> APPSTREAM_AGENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImageBuilder.getter(ImageBuilder::appstreamAgentVersion)).setter(ImageBuilder.setter(Builder::appstreamAgentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppstreamAgentVersion").build()}).build();
    private static final SdkField<List<AccessEndpoint>> ACCESS_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ImageBuilder.getter(ImageBuilder::accessEndpoints)).setter(ImageBuilder.setter(Builder::accessEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, IMAGE_ARN_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, VPC_CONFIG_FIELD, INSTANCE_TYPE_FIELD, PLATFORM_FIELD, IAM_ROLE_ARN_FIELD, STATE_FIELD, STATE_CHANGE_REASON_FIELD, CREATED_TIME_FIELD, ENABLE_DEFAULT_INTERNET_ACCESS_FIELD, DOMAIN_JOIN_INFO_FIELD, NETWORK_ACCESS_CONFIGURATION_FIELD, IMAGE_BUILDER_ERRORS_FIELD, APPSTREAM_AGENT_VERSION_FIELD, ACCESS_ENDPOINTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String imageArn;
    private final String description;
    private final String displayName;
    private final VpcConfig vpcConfig;
    private final String instanceType;
    private final String platform;
    private final String iamRoleArn;
    private final String state;
    private final ImageBuilderStateChangeReason stateChangeReason;
    private final Instant createdTime;
    private final Boolean enableDefaultInternetAccess;
    private final DomainJoinInfo domainJoinInfo;
    private final NetworkAccessConfiguration networkAccessConfiguration;
    private final List<ResourceError> imageBuilderErrors;
    private final String appstreamAgentVersion;
    private final List<AccessEndpoint> accessEndpoints;

    private ImageBuilder(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.imageArn = builder.imageArn;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.vpcConfig = builder.vpcConfig;
        this.instanceType = builder.instanceType;
        this.platform = builder.platform;
        this.iamRoleArn = builder.iamRoleArn;
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
        this.createdTime = builder.createdTime;
        this.enableDefaultInternetAccess = builder.enableDefaultInternetAccess;
        this.domainJoinInfo = builder.domainJoinInfo;
        this.networkAccessConfiguration = builder.networkAccessConfiguration;
        this.imageBuilderErrors = builder.imageBuilderErrors;
        this.appstreamAgentVersion = builder.appstreamAgentVersion;
        this.accessEndpoints = builder.accessEndpoints;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public String imageArn() {
        return this.imageArn;
    }

    public String description() {
        return this.description;
    }

    public String displayName() {
        return this.displayName;
    }

    public VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public PlatformType platform() {
        return PlatformType.fromValue(this.platform);
    }

    public String platformAsString() {
        return this.platform;
    }

    public String iamRoleArn() {
        return this.iamRoleArn;
    }

    public ImageBuilderState state() {
        return ImageBuilderState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public ImageBuilderStateChangeReason stateChangeReason() {
        return this.stateChangeReason;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public Boolean enableDefaultInternetAccess() {
        return this.enableDefaultInternetAccess;
    }

    public DomainJoinInfo domainJoinInfo() {
        return this.domainJoinInfo;
    }

    public NetworkAccessConfiguration networkAccessConfiguration() {
        return this.networkAccessConfiguration;
    }

    public boolean hasImageBuilderErrors() {
        return this.imageBuilderErrors != null && !(this.imageBuilderErrors instanceof SdkAutoConstructList);
    }

    public List<ResourceError> imageBuilderErrors() {
        return this.imageBuilderErrors;
    }

    public String appstreamAgentVersion() {
        return this.appstreamAgentVersion;
    }

    public boolean hasAccessEndpoints() {
        return this.accessEndpoints != null && !(this.accessEndpoints instanceof SdkAutoConstructList);
    }

    public List<AccessEndpoint> accessEndpoints() {
        return this.accessEndpoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDefaultInternetAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainJoinInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAccessConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageBuilderErrors());
        hashCode = 31 * hashCode + Objects.hashCode(this.appstreamAgentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessEndpoints());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageBuilder)) {
            return false;
        }
        ImageBuilder other = (ImageBuilder)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.imageArn(), other.imageArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateChangeReason(), other.stateChangeReason()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.enableDefaultInternetAccess(), other.enableDefaultInternetAccess()) && Objects.equals(this.domainJoinInfo(), other.domainJoinInfo()) && Objects.equals(this.networkAccessConfiguration(), other.networkAccessConfiguration()) && Objects.equals(this.imageBuilderErrors(), other.imageBuilderErrors()) && Objects.equals(this.appstreamAgentVersion(), other.appstreamAgentVersion()) && Objects.equals(this.accessEndpoints(), other.accessEndpoints());
    }

    public String toString() {
        return ToString.builder((String)"ImageBuilder").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("ImageArn", (Object)this.imageArn()).add("Description", (Object)this.description()).add("DisplayName", (Object)this.displayName()).add("VpcConfig", (Object)this.vpcConfig()).add("InstanceType", (Object)this.instanceType()).add("Platform", (Object)this.platformAsString()).add("IamRoleArn", (Object)this.iamRoleArn()).add("State", (Object)this.stateAsString()).add("StateChangeReason", (Object)this.stateChangeReason()).add("CreatedTime", (Object)this.createdTime()).add("EnableDefaultInternetAccess", (Object)this.enableDefaultInternetAccess()).add("DomainJoinInfo", (Object)this.domainJoinInfo()).add("NetworkAccessConfiguration", (Object)this.networkAccessConfiguration()).add("ImageBuilderErrors", this.imageBuilderErrors()).add("AppstreamAgentVersion", (Object)this.appstreamAgentVersion()).add("AccessEndpoints", this.accessEndpoints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ImageArn": {
                return Optional.ofNullable(clazz.cast(this.imageArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateChangeReason": {
                return Optional.ofNullable(clazz.cast(this.stateChangeReason()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "EnableDefaultInternetAccess": {
                return Optional.ofNullable(clazz.cast(this.enableDefaultInternetAccess()));
            }
            case "DomainJoinInfo": {
                return Optional.ofNullable(clazz.cast(this.domainJoinInfo()));
            }
            case "NetworkAccessConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkAccessConfiguration()));
            }
            case "ImageBuilderErrors": {
                return Optional.ofNullable(clazz.cast(this.imageBuilderErrors()));
            }
            case "AppstreamAgentVersion": {
                return Optional.ofNullable(clazz.cast(this.appstreamAgentVersion()));
            }
            case "AccessEndpoints": {
                return Optional.ofNullable(clazz.cast(this.accessEndpoints()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageBuilder, T> g) {
        return obj -> g.apply((ImageBuilder)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String imageArn;
        private String description;
        private String displayName;
        private VpcConfig vpcConfig;
        private String instanceType;
        private String platform;
        private String iamRoleArn;
        private String state;
        private ImageBuilderStateChangeReason stateChangeReason;
        private Instant createdTime;
        private Boolean enableDefaultInternetAccess;
        private DomainJoinInfo domainJoinInfo;
        private NetworkAccessConfiguration networkAccessConfiguration;
        private List<ResourceError> imageBuilderErrors = DefaultSdkAutoConstructList.getInstance();
        private String appstreamAgentVersion;
        private List<AccessEndpoint> accessEndpoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImageBuilder model) {
            this.name(model.name);
            this.arn(model.arn);
            this.imageArn(model.imageArn);
            this.description(model.description);
            this.displayName(model.displayName);
            this.vpcConfig(model.vpcConfig);
            this.instanceType(model.instanceType);
            this.platform(model.platform);
            this.iamRoleArn(model.iamRoleArn);
            this.state(model.state);
            this.stateChangeReason(model.stateChangeReason);
            this.createdTime(model.createdTime);
            this.enableDefaultInternetAccess(model.enableDefaultInternetAccess);
            this.domainJoinInfo(model.domainJoinInfo);
            this.networkAccessConfiguration(model.networkAccessConfiguration);
            this.imageBuilderErrors(model.imageBuilderErrors);
            this.appstreamAgentVersion(model.appstreamAgentVersion);
            this.accessEndpoints(model.accessEndpoints);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getImageArn() {
            return this.imageArn;
        }

        @Override
        public final Builder imageArn(String imageArn) {
            this.imageArn = imageArn;
            return this;
        }

        public final void setImageArn(String imageArn) {
            this.imageArn = imageArn;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getPlatformAsString() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformType platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ImageBuilderState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final ImageBuilderStateChangeReason.Builder getStateChangeReason() {
            return this.stateChangeReason != null ? this.stateChangeReason.toBuilder() : null;
        }

        @Override
        public final Builder stateChangeReason(ImageBuilderStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final void setStateChangeReason(ImageBuilderStateChangeReason.BuilderImpl stateChangeReason) {
            this.stateChangeReason = stateChangeReason != null ? stateChangeReason.build() : null;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Boolean getEnableDefaultInternetAccess() {
            return this.enableDefaultInternetAccess;
        }

        @Override
        public final Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
            return this;
        }

        public final void setEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
        }

        public final DomainJoinInfo.Builder getDomainJoinInfo() {
            return this.domainJoinInfo != null ? this.domainJoinInfo.toBuilder() : null;
        }

        @Override
        public final Builder domainJoinInfo(DomainJoinInfo domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo;
            return this;
        }

        public final void setDomainJoinInfo(DomainJoinInfo.BuilderImpl domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo != null ? domainJoinInfo.build() : null;
        }

        public final NetworkAccessConfiguration.Builder getNetworkAccessConfiguration() {
            return this.networkAccessConfiguration != null ? this.networkAccessConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder networkAccessConfiguration(NetworkAccessConfiguration networkAccessConfiguration) {
            this.networkAccessConfiguration = networkAccessConfiguration;
            return this;
        }

        public final void setNetworkAccessConfiguration(NetworkAccessConfiguration.BuilderImpl networkAccessConfiguration) {
            this.networkAccessConfiguration = networkAccessConfiguration != null ? networkAccessConfiguration.build() : null;
        }

        public final Collection<ResourceError.Builder> getImageBuilderErrors() {
            return this.imageBuilderErrors != null ? (Collection)this.imageBuilderErrors.stream().map(ResourceError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder imageBuilderErrors(Collection<ResourceError> imageBuilderErrors) {
            this.imageBuilderErrors = ResourceErrorsCopier.copy(imageBuilderErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageBuilderErrors(ResourceError ... imageBuilderErrors) {
            this.imageBuilderErrors(Arrays.asList(imageBuilderErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageBuilderErrors(Consumer<ResourceError.Builder> ... imageBuilderErrors) {
            this.imageBuilderErrors(Stream.of(imageBuilderErrors).map(c -> (ResourceError)((ResourceError.Builder)ResourceError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setImageBuilderErrors(Collection<ResourceError.BuilderImpl> imageBuilderErrors) {
            this.imageBuilderErrors = ResourceErrorsCopier.copyFromBuilder(imageBuilderErrors);
        }

        public final String getAppstreamAgentVersion() {
            return this.appstreamAgentVersion;
        }

        @Override
        public final Builder appstreamAgentVersion(String appstreamAgentVersion) {
            this.appstreamAgentVersion = appstreamAgentVersion;
            return this;
        }

        public final void setAppstreamAgentVersion(String appstreamAgentVersion) {
            this.appstreamAgentVersion = appstreamAgentVersion;
        }

        public final Collection<AccessEndpoint.Builder> getAccessEndpoints() {
            return this.accessEndpoints != null ? (Collection)this.accessEndpoints.stream().map(AccessEndpoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accessEndpoints(Collection<AccessEndpoint> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copy(accessEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(AccessEndpoint ... accessEndpoints) {
            this.accessEndpoints(Arrays.asList(accessEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(Consumer<AccessEndpoint.Builder> ... accessEndpoints) {
            this.accessEndpoints(Stream.of(accessEndpoints).map(c -> (AccessEndpoint)((AccessEndpoint.Builder)AccessEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccessEndpoints(Collection<AccessEndpoint.BuilderImpl> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copyFromBuilder(accessEndpoints);
        }

        public ImageBuilder build() {
            return new ImageBuilder(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageBuilder> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder imageArn(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder instanceType(String var1);

        public Builder platform(String var1);

        public Builder platform(PlatformType var1);

        public Builder iamRoleArn(String var1);

        public Builder state(String var1);

        public Builder state(ImageBuilderState var1);

        public Builder stateChangeReason(ImageBuilderStateChangeReason var1);

        default public Builder stateChangeReason(Consumer<ImageBuilderStateChangeReason.Builder> stateChangeReason) {
            return this.stateChangeReason((ImageBuilderStateChangeReason)((ImageBuilderStateChangeReason.Builder)ImageBuilderStateChangeReason.builder().applyMutation(stateChangeReason)).build());
        }

        public Builder createdTime(Instant var1);

        public Builder enableDefaultInternetAccess(Boolean var1);

        public Builder domainJoinInfo(DomainJoinInfo var1);

        default public Builder domainJoinInfo(Consumer<DomainJoinInfo.Builder> domainJoinInfo) {
            return this.domainJoinInfo((DomainJoinInfo)((DomainJoinInfo.Builder)DomainJoinInfo.builder().applyMutation(domainJoinInfo)).build());
        }

        public Builder networkAccessConfiguration(NetworkAccessConfiguration var1);

        default public Builder networkAccessConfiguration(Consumer<NetworkAccessConfiguration.Builder> networkAccessConfiguration) {
            return this.networkAccessConfiguration((NetworkAccessConfiguration)((NetworkAccessConfiguration.Builder)NetworkAccessConfiguration.builder().applyMutation(networkAccessConfiguration)).build());
        }

        public Builder imageBuilderErrors(Collection<ResourceError> var1);

        public Builder imageBuilderErrors(ResourceError ... var1);

        public Builder imageBuilderErrors(Consumer<ResourceError.Builder> ... var1);

        public Builder appstreamAgentVersion(String var1);

        public Builder accessEndpoints(Collection<AccessEndpoint> var1);

        public Builder accessEndpoints(AccessEndpoint ... var1);

        public Builder accessEndpoints(Consumer<AccessEndpoint.Builder> ... var1);
    }
}

