/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ImageState {
    PENDING("PENDING"),
    AVAILABLE("AVAILABLE"),
    FAILED("FAILED"),
    COPYING("COPYING"),
    DELETING("DELETING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ImageState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImageState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ImageState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImageState> knownValues() {
        return Stream.of(ImageState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

