/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.model.DomainJoinInfo;
import software.amazon.awssdk.services.appstream.model.ImageBuilderState;
import software.amazon.awssdk.services.appstream.model.ImageBuilderStateChangeReason;
import software.amazon.awssdk.services.appstream.model.PlatformType;
import software.amazon.awssdk.services.appstream.model.ResourceError;
import software.amazon.awssdk.services.appstream.model.ResourceErrorsCopier;
import software.amazon.awssdk.services.appstream.model.VpcConfig;
import software.amazon.awssdk.services.appstream.transform.ImageBuilderMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImageBuilder
implements StructuredPojo,
ToCopyableBuilder<Builder, ImageBuilder> {
    private final String name;
    private final String arn;
    private final String imageArn;
    private final String description;
    private final String displayName;
    private final VpcConfig vpcConfig;
    private final String instanceType;
    private final String platform;
    private final String state;
    private final ImageBuilderStateChangeReason stateChangeReason;
    private final Instant createdTime;
    private final Boolean enableDefaultInternetAccess;
    private final DomainJoinInfo domainJoinInfo;
    private final List<ResourceError> imageBuilderErrors;

    private ImageBuilder(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.imageArn = builder.imageArn;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.vpcConfig = builder.vpcConfig;
        this.instanceType = builder.instanceType;
        this.platform = builder.platform;
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
        this.createdTime = builder.createdTime;
        this.enableDefaultInternetAccess = builder.enableDefaultInternetAccess;
        this.domainJoinInfo = builder.domainJoinInfo;
        this.imageBuilderErrors = builder.imageBuilderErrors;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public String imageArn() {
        return this.imageArn;
    }

    public String description() {
        return this.description;
    }

    public String displayName() {
        return this.displayName;
    }

    public VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public PlatformType platform() {
        return PlatformType.fromValue(this.platform);
    }

    public String platformString() {
        return this.platform;
    }

    public ImageBuilderState state() {
        return ImageBuilderState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public ImageBuilderStateChangeReason stateChangeReason() {
        return this.stateChangeReason;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public Boolean enableDefaultInternetAccess() {
        return this.enableDefaultInternetAccess;
    }

    public DomainJoinInfo domainJoinInfo() {
        return this.domainJoinInfo;
    }

    public List<ResourceError> imageBuilderErrors() {
        return this.imageBuilderErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDefaultInternetAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainJoinInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageBuilderErrors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageBuilder)) {
            return false;
        }
        ImageBuilder other = (ImageBuilder)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.imageArn(), other.imageArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.platformString(), other.platformString()) && Objects.equals(this.stateString(), other.stateString()) && Objects.equals(this.stateChangeReason(), other.stateChangeReason()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.enableDefaultInternetAccess(), other.enableDefaultInternetAccess()) && Objects.equals(this.domainJoinInfo(), other.domainJoinInfo()) && Objects.equals(this.imageBuilderErrors(), other.imageBuilderErrors());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.imageArn() != null) {
            sb.append("ImageArn: ").append(this.imageArn()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.displayName() != null) {
            sb.append("DisplayName: ").append(this.displayName()).append(",");
        }
        if (this.vpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.vpcConfig()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.platformString() != null) {
            sb.append("Platform: ").append(this.platformString()).append(",");
        }
        if (this.stateString() != null) {
            sb.append("State: ").append(this.stateString()).append(",");
        }
        if (this.stateChangeReason() != null) {
            sb.append("StateChangeReason: ").append(this.stateChangeReason()).append(",");
        }
        if (this.createdTime() != null) {
            sb.append("CreatedTime: ").append(this.createdTime()).append(",");
        }
        if (this.enableDefaultInternetAccess() != null) {
            sb.append("EnableDefaultInternetAccess: ").append(this.enableDefaultInternetAccess()).append(",");
        }
        if (this.domainJoinInfo() != null) {
            sb.append("DomainJoinInfo: ").append(this.domainJoinInfo()).append(",");
        }
        if (this.imageBuilderErrors() != null) {
            sb.append("ImageBuilderErrors: ").append(this.imageBuilderErrors()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "ImageArn": {
                return Optional.of(clazz.cast(this.imageArn()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "DisplayName": {
                return Optional.of(clazz.cast(this.displayName()));
            }
            case "VpcConfig": {
                return Optional.of(clazz.cast(this.vpcConfig()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "Platform": {
                return Optional.of(clazz.cast(this.platformString()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "StateChangeReason": {
                return Optional.of(clazz.cast(this.stateChangeReason()));
            }
            case "CreatedTime": {
                return Optional.of(clazz.cast(this.createdTime()));
            }
            case "EnableDefaultInternetAccess": {
                return Optional.of(clazz.cast(this.enableDefaultInternetAccess()));
            }
            case "DomainJoinInfo": {
                return Optional.of(clazz.cast(this.domainJoinInfo()));
            }
            case "ImageBuilderErrors": {
                return Optional.of(clazz.cast(this.imageBuilderErrors()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageBuilderMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String imageArn;
        private String description;
        private String displayName;
        private VpcConfig vpcConfig;
        private String instanceType;
        private String platform;
        private String state;
        private ImageBuilderStateChangeReason stateChangeReason;
        private Instant createdTime;
        private Boolean enableDefaultInternetAccess;
        private DomainJoinInfo domainJoinInfo;
        private List<ResourceError> imageBuilderErrors;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageBuilder model) {
            this.name(model.name);
            this.arn(model.arn);
            this.imageArn(model.imageArn);
            this.description(model.description);
            this.displayName(model.displayName);
            this.vpcConfig(model.vpcConfig);
            this.instanceType(model.instanceType);
            this.platform(model.platform);
            this.state(model.state);
            this.stateChangeReason(model.stateChangeReason);
            this.createdTime(model.createdTime);
            this.enableDefaultInternetAccess(model.enableDefaultInternetAccess);
            this.domainJoinInfo(model.domainJoinInfo);
            this.imageBuilderErrors(model.imageBuilderErrors);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getImageArn() {
            return this.imageArn;
        }

        @Override
        public final Builder imageArn(String imageArn) {
            this.imageArn = imageArn;
            return this;
        }

        public final void setImageArn(String imageArn) {
            this.imageArn = imageArn;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformType platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ImageBuilderState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final ImageBuilderStateChangeReason.Builder getStateChangeReason() {
            return this.stateChangeReason != null ? this.stateChangeReason.toBuilder() : null;
        }

        @Override
        public final Builder stateChangeReason(ImageBuilderStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final void setStateChangeReason(ImageBuilderStateChangeReason.BuilderImpl stateChangeReason) {
            this.stateChangeReason = stateChangeReason != null ? stateChangeReason.build() : null;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Boolean getEnableDefaultInternetAccess() {
            return this.enableDefaultInternetAccess;
        }

        @Override
        public final Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
            return this;
        }

        public final void setEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
        }

        public final DomainJoinInfo.Builder getDomainJoinInfo() {
            return this.domainJoinInfo != null ? this.domainJoinInfo.toBuilder() : null;
        }

        @Override
        public final Builder domainJoinInfo(DomainJoinInfo domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo;
            return this;
        }

        public final void setDomainJoinInfo(DomainJoinInfo.BuilderImpl domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo != null ? domainJoinInfo.build() : null;
        }

        public final Collection<ResourceError.Builder> getImageBuilderErrors() {
            return this.imageBuilderErrors != null ? (Collection)this.imageBuilderErrors.stream().map(ResourceError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder imageBuilderErrors(Collection<ResourceError> imageBuilderErrors) {
            this.imageBuilderErrors = ResourceErrorsCopier.copy(imageBuilderErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageBuilderErrors(ResourceError ... imageBuilderErrors) {
            this.imageBuilderErrors(Arrays.asList(imageBuilderErrors));
            return this;
        }

        public final void setImageBuilderErrors(Collection<ResourceError.BuilderImpl> imageBuilderErrors) {
            this.imageBuilderErrors = ResourceErrorsCopier.copyFromBuilder(imageBuilderErrors);
        }

        public ImageBuilder build() {
            return new ImageBuilder(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImageBuilder> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder imageArn(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().apply(vpcConfig)).build());
        }

        public Builder instanceType(String var1);

        public Builder platform(String var1);

        public Builder platform(PlatformType var1);

        public Builder state(String var1);

        public Builder state(ImageBuilderState var1);

        public Builder stateChangeReason(ImageBuilderStateChangeReason var1);

        default public Builder stateChangeReason(Consumer<ImageBuilderStateChangeReason.Builder> stateChangeReason) {
            return this.stateChangeReason((ImageBuilderStateChangeReason)((ImageBuilderStateChangeReason.Builder)ImageBuilderStateChangeReason.builder().apply(stateChangeReason)).build());
        }

        public Builder createdTime(Instant var1);

        public Builder enableDefaultInternetAccess(Boolean var1);

        public Builder domainJoinInfo(DomainJoinInfo var1);

        default public Builder domainJoinInfo(Consumer<DomainJoinInfo.Builder> domainJoinInfo) {
            return this.domainJoinInfo((DomainJoinInfo)((DomainJoinInfo.Builder)DomainJoinInfo.builder().apply(domainJoinInfo)).build());
        }

        public Builder imageBuilderErrors(Collection<ResourceError> var1);

        public Builder imageBuilderErrors(ResourceError ... var1);
    }
}

