/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateStreamingURLRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, CreateStreamingURLRequest> {
    private final String stackName;
    private final String fleetName;
    private final String userId;
    private final String applicationId;
    private final Long validity;
    private final String sessionContext;

    private CreateStreamingURLRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.fleetName = builder.fleetName;
        this.userId = builder.userId;
        this.applicationId = builder.applicationId;
        this.validity = builder.validity;
        this.sessionContext = builder.sessionContext;
    }

    public String stackName() {
        return this.stackName;
    }

    public String fleetName() {
        return this.fleetName;
    }

    public String userId() {
        return this.userId;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public Long validity() {
        return this.validity;
    }

    public String sessionContext() {
        return this.sessionContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.validity());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionContext());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamingURLRequest)) {
            return false;
        }
        CreateStreamingURLRequest other = (CreateStreamingURLRequest)((Object)obj);
        return Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.fleetName(), other.fleetName()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.validity(), other.validity()) && Objects.equals(this.sessionContext(), other.sessionContext());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stackName() != null) {
            sb.append("StackName: ").append(this.stackName()).append(",");
        }
        if (this.fleetName() != null) {
            sb.append("FleetName: ").append(this.fleetName()).append(",");
        }
        if (this.userId() != null) {
            sb.append("UserId: ").append(this.userId()).append(",");
        }
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.validity() != null) {
            sb.append("Validity: ").append(this.validity()).append(",");
        }
        if (this.sessionContext() != null) {
            sb.append("SessionContext: ").append(this.sessionContext()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackName": {
                return Optional.of(clazz.cast(this.stackName()));
            }
            case "FleetName": {
                return Optional.of(clazz.cast(this.fleetName()));
            }
            case "UserId": {
                return Optional.of(clazz.cast(this.userId()));
            }
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "Validity": {
                return Optional.of(clazz.cast(this.validity()));
            }
            case "SessionContext": {
                return Optional.of(clazz.cast(this.sessionContext()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String stackName;
        private String fleetName;
        private String userId;
        private String applicationId;
        private Long validity;
        private String sessionContext;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamingURLRequest model) {
            this.stackName(model.stackName);
            this.fleetName(model.fleetName);
            this.userId(model.userId);
            this.applicationId(model.applicationId);
            this.validity(model.validity);
            this.sessionContext(model.sessionContext);
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getFleetName() {
            return this.fleetName;
        }

        @Override
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final Long getValidity() {
            return this.validity;
        }

        @Override
        public final Builder validity(Long validity) {
            this.validity = validity;
            return this;
        }

        public final void setValidity(Long validity) {
            this.validity = validity;
        }

        public final String getSessionContext() {
            return this.sessionContext;
        }

        @Override
        public final Builder sessionContext(String sessionContext) {
            this.sessionContext = sessionContext;
            return this;
        }

        public final void setSessionContext(String sessionContext) {
            this.sessionContext = sessionContext;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateStreamingURLRequest build() {
            return new CreateStreamingURLRequest(this);
        }
    }

    public static interface Builder
    extends AppStreamRequest.Builder,
    CopyableBuilder<Builder, CreateStreamingURLRequest> {
        public Builder stackName(String var1);

        public Builder fleetName(String var1);

        public Builder userId(String var1);

        public Builder applicationId(String var1);

        public Builder validity(Long var1);

        public Builder sessionContext(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

