/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.model.ImageBuilder;

@SdkInternalApi
public class ImageBuilderMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").build();
    private static final MarshallingInfo<String> IMAGEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageArn").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisplayName").build();
    private static final MarshallingInfo<StructuredPojo> VPCCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcConfig").build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").build();
    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Platform").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<StructuredPojo> STATECHANGEREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateChangeReason").build();
    private static final MarshallingInfo<Instant> CREATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTime").build();
    private static final MarshallingInfo<Boolean> ENABLEDEFAULTINTERNETACCESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnableDefaultInternetAccess").build();
    private static final MarshallingInfo<StructuredPojo> DOMAINJOININFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainJoinInfo").build();
    private static final MarshallingInfo<List> IMAGEBUILDERERRORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageBuilderErrors").build();
    private static final ImageBuilderMarshaller INSTANCE = new ImageBuilderMarshaller();

    public static ImageBuilderMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ImageBuilder imageBuilder, ProtocolMarshaller protocolMarshaller) {
        if (imageBuilder == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)imageBuilder.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.imageArn(), IMAGEARN_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.displayName(), DISPLAYNAME_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.vpcConfig(), VPCCONFIG_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.instanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.platformString(), PLATFORM_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.stateString(), STATE_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.stateChangeReason(), STATECHANGEREASON_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.createdTime(), CREATEDTIME_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.enableDefaultInternetAccess(), ENABLEDEFAULTINTERNETACCESS_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.domainJoinInfo(), DOMAINJOININFO_BINDING);
            protocolMarshaller.marshall(imageBuilder.imageBuilderErrors(), IMAGEBUILDERERRORS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

