/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.appstream.model.Stack;
import software.amazon.awssdk.services.appstream.transform.StackErrorUnmarshaller;
import software.amazon.awssdk.services.appstream.transform.StorageConnectorUnmarshaller;

public class StackUnmarshaller
implements Unmarshaller<Stack, JsonUnmarshallerContext> {
    private static StackUnmarshaller INSTANCE;

    public Stack unmarshall(JsonUnmarshallerContext context) throws Exception {
        Stack.Builder stackBuilder = Stack.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Arn", targetDepth)) {
                    context.nextToken();
                    stackBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    stackBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    stackBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DisplayName", targetDepth)) {
                    context.nextToken();
                    stackBuilder.displayName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreatedTime", targetDepth)) {
                    context.nextToken();
                    stackBuilder.createdTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("StorageConnectors", targetDepth)) {
                    context.nextToken();
                    stackBuilder.storageConnectors(new ListUnmarshaller((Unmarshaller)StorageConnectorUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("StackErrors", targetDepth)) {
                    context.nextToken();
                    stackBuilder.stackErrors(new ListUnmarshaller((Unmarshaller)StackErrorUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Stack)stackBuilder.build();
    }

    public static StackUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StackUnmarshaller();
        }
        return INSTANCE;
    }
}

