/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appstream.model.NetworkAccessConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NetworkAccessConfigurationMarshaller {
    private static final MarshallingInfo<String> ENIPRIVATEIPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EniPrivateIpAddress").isBinary(false).build();
    private static final MarshallingInfo<String> ENIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EniId").isBinary(false).build();
    private static final NetworkAccessConfigurationMarshaller INSTANCE = new NetworkAccessConfigurationMarshaller();

    private NetworkAccessConfigurationMarshaller() {
    }

    public static NetworkAccessConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NetworkAccessConfiguration networkAccessConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)networkAccessConfiguration, (String)"networkAccessConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)networkAccessConfiguration.eniPrivateIpAddress(), ENIPRIVATEIPADDRESS_BINDING);
            protocolMarshaller.marshall((Object)networkAccessConfiguration.eniId(), ENIID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

