/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appstream.model.ImagePermissions;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ImagePermissionsMarshaller {
    private static final MarshallingInfo<Boolean> ALLOWFLEET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allowFleet").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ALLOWIMAGEBUILDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allowImageBuilder").isBinary(false).build();
    private static final ImagePermissionsMarshaller INSTANCE = new ImagePermissionsMarshaller();

    private ImagePermissionsMarshaller() {
    }

    public static ImagePermissionsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ImagePermissions imagePermissions, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)imagePermissions, (String)"imagePermissions");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)imagePermissions.allowFleet(), ALLOWFLEET_BINDING);
            protocolMarshaller.marshall((Object)imagePermissions.allowImageBuilder(), ALLOWIMAGEBUILDER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

