/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.ImagePermissionsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImagePermissions
implements StructuredPojo,
ToCopyableBuilder<Builder, ImagePermissions> {
    private final Boolean allowFleet;
    private final Boolean allowImageBuilder;

    private ImagePermissions(BuilderImpl builder) {
        this.allowFleet = builder.allowFleet;
        this.allowImageBuilder = builder.allowImageBuilder;
    }

    public Boolean allowFleet() {
        return this.allowFleet;
    }

    public Boolean allowImageBuilder() {
        return this.allowImageBuilder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allowFleet());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowImageBuilder());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImagePermissions)) {
            return false;
        }
        ImagePermissions other = (ImagePermissions)obj;
        return Objects.equals(this.allowFleet(), other.allowFleet()) && Objects.equals(this.allowImageBuilder(), other.allowImageBuilder());
    }

    public String toString() {
        return ToString.builder((String)"ImagePermissions").add("AllowFleet", (Object)this.allowFleet()).add("AllowImageBuilder", (Object)this.allowImageBuilder()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allowFleet": {
                return Optional.ofNullable(clazz.cast(this.allowFleet()));
            }
            case "allowImageBuilder": {
                return Optional.ofNullable(clazz.cast(this.allowImageBuilder()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImagePermissionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean allowFleet;
        private Boolean allowImageBuilder;

        private BuilderImpl() {
        }

        private BuilderImpl(ImagePermissions model) {
            this.allowFleet(model.allowFleet);
            this.allowImageBuilder(model.allowImageBuilder);
        }

        public final Boolean getAllowFleet() {
            return this.allowFleet;
        }

        @Override
        public final Builder allowFleet(Boolean allowFleet) {
            this.allowFleet = allowFleet;
            return this;
        }

        public final void setAllowFleet(Boolean allowFleet) {
            this.allowFleet = allowFleet;
        }

        public final Boolean getAllowImageBuilder() {
            return this.allowImageBuilder;
        }

        @Override
        public final Builder allowImageBuilder(Boolean allowImageBuilder) {
            this.allowImageBuilder = allowImageBuilder;
            return this;
        }

        public final void setAllowImageBuilder(Boolean allowImageBuilder) {
            this.allowImageBuilder = allowImageBuilder;
        }

        public ImagePermissions build() {
            return new ImagePermissions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImagePermissions> {
        public Builder allowFleet(Boolean var1);

        public Builder allowImageBuilder(Boolean var1);
    }
}

