/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appstream.model.CreateStreamingUrlRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateStreamingUrlRequestModelMarshaller {
    private static final MarshallingInfo<String> STACKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackName").isBinary(false).build();
    private static final MarshallingInfo<String> FLEETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FleetName").isBinary(false).build();
    private static final MarshallingInfo<String> USERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserId").isBinary(false).build();
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationId").isBinary(false).build();
    private static final MarshallingInfo<Long> VALIDITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Validity").isBinary(false).build();
    private static final MarshallingInfo<String> SESSIONCONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SessionContext").isBinary(false).build();
    private static final CreateStreamingUrlRequestModelMarshaller INSTANCE = new CreateStreamingUrlRequestModelMarshaller();

    private CreateStreamingUrlRequestModelMarshaller() {
    }

    public static CreateStreamingUrlRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateStreamingUrlRequest createStreamingUrlRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createStreamingUrlRequest), (String)"createStreamingUrlRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createStreamingUrlRequest.stackName(), STACKNAME_BINDING);
            protocolMarshaller.marshall((Object)createStreamingUrlRequest.fleetName(), FLEETNAME_BINDING);
            protocolMarshaller.marshall((Object)createStreamingUrlRequest.userId(), USERID_BINDING);
            protocolMarshaller.marshall((Object)createStreamingUrlRequest.applicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall((Object)createStreamingUrlRequest.validity(), VALIDITY_BINDING);
            protocolMarshaller.marshall((Object)createStreamingUrlRequest.sessionContext(), SESSIONCONTEXT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

