/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.DomainJoinInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainJoinInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, DomainJoinInfo> {
    private final String directoryName;
    private final String organizationalUnitDistinguishedName;

    private DomainJoinInfo(BuilderImpl builder) {
        this.directoryName = builder.directoryName;
        this.organizationalUnitDistinguishedName = builder.organizationalUnitDistinguishedName;
    }

    public String directoryName() {
        return this.directoryName;
    }

    public String organizationalUnitDistinguishedName() {
        return this.organizationalUnitDistinguishedName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationalUnitDistinguishedName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainJoinInfo)) {
            return false;
        }
        DomainJoinInfo other = (DomainJoinInfo)obj;
        return Objects.equals(this.directoryName(), other.directoryName()) && Objects.equals(this.organizationalUnitDistinguishedName(), other.organizationalUnitDistinguishedName());
    }

    public String toString() {
        return ToString.builder((String)"DomainJoinInfo").add("DirectoryName", (Object)this.directoryName()).add("OrganizationalUnitDistinguishedName", (Object)this.organizationalUnitDistinguishedName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryName": {
                return Optional.ofNullable(clazz.cast(this.directoryName()));
            }
            case "OrganizationalUnitDistinguishedName": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitDistinguishedName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DomainJoinInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String directoryName;
        private String organizationalUnitDistinguishedName;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainJoinInfo model) {
            this.directoryName(model.directoryName);
            this.organizationalUnitDistinguishedName(model.organizationalUnitDistinguishedName);
        }

        public final String getDirectoryName() {
            return this.directoryName;
        }

        @Override
        public final Builder directoryName(String directoryName) {
            this.directoryName = directoryName;
            return this;
        }

        public final void setDirectoryName(String directoryName) {
            this.directoryName = directoryName;
        }

        public final String getOrganizationalUnitDistinguishedName() {
            return this.organizationalUnitDistinguishedName;
        }

        @Override
        public final Builder organizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
            this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
            return this;
        }

        public final void setOrganizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
            this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
        }

        public DomainJoinInfo build() {
            return new DomainJoinInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DomainJoinInfo> {
        public Builder directoryName(String var1);

        public Builder organizationalUnitDistinguishedName(String var1);
    }
}

