/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.appstream.model.AppStreamResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStreamingUrlResponse
extends AppStreamResponse
implements ToCopyableBuilder<Builder, CreateStreamingUrlResponse> {
    private final String streamingURL;
    private final Instant expires;

    private CreateStreamingUrlResponse(BuilderImpl builder) {
        super(builder);
        this.streamingURL = builder.streamingURL;
        this.expires = builder.expires;
    }

    public String streamingURL() {
        return this.streamingURL;
    }

    public Instant expires() {
        return this.expires;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.expires());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamingUrlResponse)) {
            return false;
        }
        CreateStreamingUrlResponse other = (CreateStreamingUrlResponse)((Object)obj);
        return Objects.equals(this.streamingURL(), other.streamingURL()) && Objects.equals(this.expires(), other.expires());
    }

    public String toString() {
        return ToString.builder((String)"CreateStreamingUrlResponse").add("StreamingURL", (Object)this.streamingURL()).add("Expires", (Object)this.expires()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamingURL": {
                return Optional.ofNullable(clazz.cast(this.streamingURL()));
            }
            case "Expires": {
                return Optional.ofNullable(clazz.cast(this.expires()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AppStreamResponse.BuilderImpl
    implements Builder {
        private String streamingURL;
        private Instant expires;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamingUrlResponse model) {
            super(model);
            this.streamingURL(model.streamingURL);
            this.expires(model.expires);
        }

        public final String getStreamingURL() {
            return this.streamingURL;
        }

        @Override
        public final Builder streamingURL(String streamingURL) {
            this.streamingURL = streamingURL;
            return this;
        }

        public final void setStreamingURL(String streamingURL) {
            this.streamingURL = streamingURL;
        }

        public final Instant getExpires() {
            return this.expires;
        }

        @Override
        public final Builder expires(Instant expires) {
            this.expires = expires;
            return this;
        }

        public final void setExpires(Instant expires) {
            this.expires = expires;
        }

        @Override
        public CreateStreamingUrlResponse build() {
            return new CreateStreamingUrlResponse(this);
        }
    }

    public static interface Builder
    extends AppStreamResponse.Builder,
    CopyableBuilder<Builder, CreateStreamingUrlResponse> {
        public Builder streamingURL(String var1);

        public Builder expires(Instant var1);
    }
}

