/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.appstream.model.AppStreamResponse;
import software.amazon.awssdk.services.appstream.model.Fleet;
import software.amazon.awssdk.services.appstream.model.FleetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeFleetsResponse
extends AppStreamResponse
implements ToCopyableBuilder<Builder, DescribeFleetsResponse> {
    private final List<Fleet> fleets;
    private final String nextToken;

    private DescribeFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.fleets = builder.fleets;
        this.nextToken = builder.nextToken;
    }

    public List<Fleet> fleets() {
        return this.fleets;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleets());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetsResponse)) {
            return false;
        }
        DescribeFleetsResponse other = (DescribeFleetsResponse)((Object)obj);
        return Objects.equals(this.fleets(), other.fleets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeFleetsResponse").add("Fleets", this.fleets()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Fleets": {
                return Optional.of(clazz.cast(this.fleets()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AppStreamResponse.BuilderImpl
    implements Builder {
        private List<Fleet> fleets;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetsResponse model) {
            super(model);
            this.fleets(model.fleets);
            this.nextToken(model.nextToken);
        }

        public final Collection<Fleet.Builder> getFleets() {
            return this.fleets != null ? (Collection)this.fleets.stream().map(Fleet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fleets(Collection<Fleet> fleets) {
            this.fleets = FleetListCopier.copy(fleets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleets(Fleet ... fleets) {
            this.fleets(Arrays.asList(fleets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleets(Consumer<Fleet.Builder> ... fleets) {
            this.fleets(Stream.of(fleets).map(c -> (Fleet)((Fleet.Builder)Fleet.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFleets(Collection<Fleet.BuilderImpl> fleets) {
            this.fleets = FleetListCopier.copyFromBuilder(fleets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeFleetsResponse build() {
            return new DescribeFleetsResponse(this);
        }
    }

    public static interface Builder
    extends AppStreamResponse.Builder,
    CopyableBuilder<Builder, DescribeFleetsResponse> {
        public Builder fleets(Collection<Fleet> var1);

        public Builder fleets(Fleet ... var1);

        public Builder fleets(Consumer<Fleet.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

