/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.appstream.model.Session;
import software.amazon.awssdk.services.appstream.model.SessionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSessionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeSessionsResponse> {
    private final List<Session> sessions;
    private final String nextToken;

    private DescribeSessionsResponse(BuilderImpl builder) {
        this.sessions = builder.sessions;
        this.nextToken = builder.nextToken;
    }

    public List<Session> sessions() {
        return this.sessions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sessions() == null ? 0 : this.sessions().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSessionsResponse)) {
            return false;
        }
        DescribeSessionsResponse other = (DescribeSessionsResponse)((Object)obj);
        if (other.sessions() == null ^ this.sessions() == null) {
            return false;
        }
        if (other.sessions() != null && !other.sessions().equals(this.sessions())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sessions() != null) {
            sb.append("Sessions: ").append(this.sessions()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Session> sessions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSessionsResponse model) {
            this.setSessions(model.sessions);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Session> getSessions() {
            return this.sessions;
        }

        @Override
        public final Builder sessions(Collection<Session> sessions) {
            this.sessions = SessionListCopier.copy(sessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessions(Session ... sessions) {
            if (this.sessions == null) {
                this.sessions = new ArrayList<Session>(sessions.length);
            }
            for (Session e : sessions) {
                this.sessions.add(e);
            }
            return this;
        }

        public final void setSessions(Collection<Session> sessions) {
            this.sessions = SessionListCopier.copy(sessions);
        }

        @SafeVarargs
        public final void setSessions(Session ... sessions) {
            if (this.sessions == null) {
                this.sessions = new ArrayList<Session>(sessions.length);
            }
            for (Session e : sessions) {
                this.sessions.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeSessionsResponse build() {
            return new DescribeSessionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSessionsResponse> {
        public Builder sessions(Collection<Session> var1);

        public Builder sessions(Session ... var1);

        public Builder nextToken(String var1);
    }
}

