/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.services.apprunner.AppRunnerBaseClientBuilder;
import software.amazon.awssdk.services.apprunner.endpoints.AppRunnerEndpointProvider;
import software.amazon.awssdk.services.apprunner.endpoints.internal.AppRunnerEndpointAuthSchemeInterceptor;
import software.amazon.awssdk.services.apprunner.endpoints.internal.AppRunnerRequestSetEndpointInterceptor;
import software.amazon.awssdk.services.apprunner.endpoints.internal.AppRunnerResolveEndpointInterceptor;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
abstract class DefaultAppRunnerBaseClientBuilder<B extends AppRunnerBaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    DefaultAppRunnerBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "apprunner";
    }

    protected final String serviceName() {
        return "AppRunner";
    }

    protected final SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration config) {
        return config.merge(c -> c.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)this.defaultEndpointProvider()).option((ClientOption)SdkAdvancedClientOption.SIGNER, (Object)this.defaultSigner()).option((ClientOption)SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, (Object)false));
    }

    protected final SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration config) {
        ArrayList<Object> endpointInterceptors = new ArrayList<Object>();
        endpointInterceptors.add(new AppRunnerResolveEndpointInterceptor());
        endpointInterceptors.add(new AppRunnerEndpointAuthSchemeInterceptor());
        endpointInterceptors.add(new AppRunnerRequestSetEndpointInterceptor());
        ClasspathInterceptorChainFactory interceptorFactory = new ClasspathInterceptorChainFactory();
        List interceptors = interceptorFactory.getInterceptors("software/amazon/awssdk/services/apprunner/execution.interceptors");
        ArrayList additionalInterceptors = new ArrayList();
        interceptors = CollectionUtils.mergeLists(endpointInterceptors, (List)interceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, additionalInterceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, (List)((List)config.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS)));
        return config.toBuilder().option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS, (Object)interceptors).build();
    }

    private Signer defaultSigner() {
        return Aws4Signer.create();
    }

    protected final String signingName() {
        return "apprunner";
    }

    private AppRunnerEndpointProvider defaultEndpointProvider() {
        return AppRunnerEndpointProvider.defaultProvider();
    }
}

