/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apprunner.AppRunnerAsyncClient;
import software.amazon.awssdk.services.apprunner.model.DescribeCustomDomainsRequest;
import software.amazon.awssdk.services.apprunner.model.DescribeCustomDomainsResponse;

public class DescribeCustomDomainsPublisher
implements SdkPublisher<DescribeCustomDomainsResponse> {
    private final AppRunnerAsyncClient client;
    private final DescribeCustomDomainsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCustomDomainsPublisher(AppRunnerAsyncClient client, DescribeCustomDomainsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCustomDomainsPublisher(AppRunnerAsyncClient client, DescribeCustomDomainsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCustomDomainsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCustomDomainsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeCustomDomainsResponseFetcher
    implements AsyncPageFetcher<DescribeCustomDomainsResponse> {
        private DescribeCustomDomainsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCustomDomainsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeCustomDomainsResponse> nextPage(DescribeCustomDomainsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCustomDomainsPublisher.this.client.describeCustomDomains(DescribeCustomDomainsPublisher.this.firstRequest);
            }
            return DescribeCustomDomainsPublisher.this.client.describeCustomDomains((DescribeCustomDomainsRequest)((Object)DescribeCustomDomainsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

