/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VirtualNodeRef
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VirtualNodeRef> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VirtualNodeRef.getter(VirtualNodeRef::arn)).setter(VirtualNodeRef.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VirtualNodeRef.getter(VirtualNodeRef::meshName)).setter(VirtualNodeRef.setter(Builder::meshName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meshName").build()}).build();
    private static final SdkField<String> VIRTUAL_NODE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VirtualNodeRef.getter(VirtualNodeRef::virtualNodeName)).setter(VirtualNodeRef.setter(Builder::virtualNodeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualNodeName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, MESH_NAME_FIELD, VIRTUAL_NODE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String meshName;
    private final String virtualNodeName;

    private VirtualNodeRef(BuilderImpl builder) {
        this.arn = builder.arn;
        this.meshName = builder.meshName;
        this.virtualNodeName = builder.virtualNodeName;
    }

    public String arn() {
        return this.arn;
    }

    public String meshName() {
        return this.meshName;
    }

    public String virtualNodeName() {
        return this.virtualNodeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.meshName());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualNodeName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualNodeRef)) {
            return false;
        }
        VirtualNodeRef other = (VirtualNodeRef)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.meshName(), other.meshName()) && Objects.equals(this.virtualNodeName(), other.virtualNodeName());
    }

    public String toString() {
        return ToString.builder((String)"VirtualNodeRef").add("Arn", (Object)this.arn()).add("MeshName", (Object)this.meshName()).add("VirtualNodeName", (Object)this.virtualNodeName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "meshName": {
                return Optional.ofNullable(clazz.cast(this.meshName()));
            }
            case "virtualNodeName": {
                return Optional.ofNullable(clazz.cast(this.virtualNodeName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualNodeRef, T> g) {
        return obj -> g.apply((VirtualNodeRef)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String meshName;
        private String virtualNodeName;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualNodeRef model) {
            this.arn(model.arn);
            this.meshName(model.meshName);
            this.virtualNodeName(model.virtualNodeName);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getMeshName() {
            return this.meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final String getVirtualNodeName() {
            return this.virtualNodeName;
        }

        @Override
        public final Builder virtualNodeName(String virtualNodeName) {
            this.virtualNodeName = virtualNodeName;
            return this;
        }

        public final void setVirtualNodeName(String virtualNodeName) {
            this.virtualNodeName = virtualNodeName;
        }

        public VirtualNodeRef build() {
            return new VirtualNodeRef(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VirtualNodeRef> {
        public Builder arn(String var1);

        public Builder meshName(String var1);

        public Builder virtualNodeName(String var1);
    }
}

