/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a gateway route target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GatewayRouteTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<GatewayRouteTarget.Builder, GatewayRouteTarget> {
    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("port")
            .getter(getter(GatewayRouteTarget::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<GatewayRouteVirtualService> VIRTUAL_SERVICE_FIELD = SdkField
            .<GatewayRouteVirtualService> builder(MarshallingType.SDK_POJO).memberName("virtualService")
            .getter(getter(GatewayRouteTarget::virtualService)).setter(setter(Builder::virtualService))
            .constructor(GatewayRouteVirtualService::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualService").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_FIELD,
            VIRTUAL_SERVICE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer port;

    private final GatewayRouteVirtualService virtualService;

    private GatewayRouteTarget(BuilderImpl builder) {
        this.port = builder.port;
        this.virtualService = builder.virtualService;
    }

    /**
     * <p>
     * The port number of the gateway route target.
     * </p>
     * 
     * @return The port number of the gateway route target.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * An object that represents a virtual service gateway route target.
     * </p>
     * 
     * @return An object that represents a virtual service gateway route target.
     */
    public final GatewayRouteVirtualService virtualService() {
        return virtualService;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(virtualService());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatewayRouteTarget)) {
            return false;
        }
        GatewayRouteTarget other = (GatewayRouteTarget) obj;
        return Objects.equals(port(), other.port()) && Objects.equals(virtualService(), other.virtualService());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GatewayRouteTarget").add("Port", port()).add("VirtualService", virtualService()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        case "virtualService":
            return Optional.ofNullable(clazz.cast(virtualService()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("port", PORT_FIELD);
        map.put("virtualService", VIRTUAL_SERVICE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GatewayRouteTarget, T> g) {
        return obj -> g.apply((GatewayRouteTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GatewayRouteTarget> {
        /**
         * <p>
         * The port number of the gateway route target.
         * </p>
         * 
         * @param port
         *        The port number of the gateway route target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * An object that represents a virtual service gateway route target.
         * </p>
         * 
         * @param virtualService
         *        An object that represents a virtual service gateway route target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualService(GatewayRouteVirtualService virtualService);

        /**
         * <p>
         * An object that represents a virtual service gateway route target.
         * </p>
         * This is a convenience method that creates an instance of the {@link GatewayRouteVirtualService.Builder}
         * avoiding the need to create one manually via {@link GatewayRouteVirtualService#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GatewayRouteVirtualService.Builder#build()} is called immediately
         * and its result is passed to {@link #virtualService(GatewayRouteVirtualService)}.
         * 
         * @param virtualService
         *        a consumer that will call methods on {@link GatewayRouteVirtualService.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #virtualService(GatewayRouteVirtualService)
         */
        default Builder virtualService(Consumer<GatewayRouteVirtualService.Builder> virtualService) {
            return virtualService(GatewayRouteVirtualService.builder().applyMutation(virtualService).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer port;

        private GatewayRouteVirtualService virtualService;

        private BuilderImpl() {
        }

        private BuilderImpl(GatewayRouteTarget model) {
            port(model.port);
            virtualService(model.virtualService);
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final GatewayRouteVirtualService.Builder getVirtualService() {
            return virtualService != null ? virtualService.toBuilder() : null;
        }

        public final void setVirtualService(GatewayRouteVirtualService.BuilderImpl virtualService) {
            this.virtualService = virtualService != null ? virtualService.build() : null;
        }

        @Override
        public final Builder virtualService(GatewayRouteVirtualService virtualService) {
            this.virtualService = virtualService;
            return this;
        }

        @Override
        public GatewayRouteTarget build() {
            return new GatewayRouteTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
