/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the range of values to match on. The first character of the range is included in the range,
 * though the last character is not. For example, if the range specified were 1-100, only values 1-99 would be matched.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MatchRange implements SdkPojo, Serializable, ToCopyableBuilder<MatchRange.Builder, MatchRange> {
    private static final SdkField<Long> END_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("end")
            .getter(getter(MatchRange::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("end").build()).build();

    private static final SdkField<Long> START_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("start")
            .getter(getter(MatchRange::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_FIELD, START_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long end;

    private final Long start;

    private MatchRange(BuilderImpl builder) {
        this.end = builder.end;
        this.start = builder.start;
    }

    /**
     * <p>
     * The end of the range.
     * </p>
     * 
     * @return The end of the range.
     */
    public final Long end() {
        return end;
    }

    /**
     * <p>
     * The start of the range.
     * </p>
     * 
     * @return The start of the range.
     */
    public final Long start() {
        return start;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(end());
        hashCode = 31 * hashCode + Objects.hashCode(start());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchRange)) {
            return false;
        }
        MatchRange other = (MatchRange) obj;
        return Objects.equals(end(), other.end()) && Objects.equals(start(), other.start());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MatchRange").add("End", end()).add("Start", start()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "end":
            return Optional.ofNullable(clazz.cast(end()));
        case "start":
            return Optional.ofNullable(clazz.cast(start()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("end", END_FIELD);
        map.put("start", START_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MatchRange, T> g) {
        return obj -> g.apply((MatchRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MatchRange> {
        /**
         * <p>
         * The end of the range.
         * </p>
         * 
         * @param end
         *        The end of the range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(Long end);

        /**
         * <p>
         * The start of the range.
         * </p>
         * 
         * @param start
         *        The start of the range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Long start);
    }

    static final class BuilderImpl implements Builder {
        private Long end;

        private Long start;

        private BuilderImpl() {
        }

        private BuilderImpl(MatchRange model) {
            end(model.end);
            start(model.start);
        }

        public final Long getEnd() {
            return end;
        }

        public final void setEnd(Long end) {
            this.end = end;
        }

        @Override
        public final Builder end(Long end) {
            this.end = end;
            return this;
        }

        public final Long getStart() {
            return start;
        }

        public final void setStart(Long start) {
            this.start = start;
        }

        @Override
        public final Builder start(Long start) {
            this.start = start;
            return this;
        }

        @Override
        public MatchRange build() {
            return new MatchRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
