/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appmesh.AppMeshAsyncClient;
import software.amazon.awssdk.services.appmesh.internal.UserAgentUtils;
import software.amazon.awssdk.services.appmesh.model.ListVirtualServicesRequest;
import software.amazon.awssdk.services.appmesh.model.ListVirtualServicesResponse;
import software.amazon.awssdk.services.appmesh.model.VirtualServiceRef;

public class ListVirtualServicesPublisher
implements SdkPublisher<ListVirtualServicesResponse> {
    private final AppMeshAsyncClient client;
    private final ListVirtualServicesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVirtualServicesPublisher(AppMeshAsyncClient client, ListVirtualServicesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVirtualServicesPublisher(AppMeshAsyncClient client, ListVirtualServicesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVirtualServicesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVirtualServicesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VirtualServiceRef> virtualServices() {
        Function<ListVirtualServicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.virtualServices() != null) {
                return response.virtualServices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListVirtualServicesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListVirtualServicesResponseFetcher
    implements AsyncPageFetcher<ListVirtualServicesResponse> {
        private ListVirtualServicesResponseFetcher() {
        }

        public boolean hasNextPage(ListVirtualServicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVirtualServicesResponse> nextPage(ListVirtualServicesResponse previousPage) {
            if (previousPage == null) {
                return ListVirtualServicesPublisher.this.client.listVirtualServices(ListVirtualServicesPublisher.this.firstRequest);
            }
            return ListVirtualServicesPublisher.this.client.listVirtualServices((ListVirtualServicesRequest)((Object)ListVirtualServicesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

