/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appmesh.model.AppMeshRequest;
import software.amazon.awssdk.services.appmesh.model.GatewayRouteSpec;
import software.amazon.awssdk.services.appmesh.model.TagListCopier;
import software.amazon.awssdk.services.appmesh.model.TagRef;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGatewayRouteRequest
extends AppMeshRequest
implements ToCopyableBuilder<Builder, CreateGatewayRouteRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateGatewayRouteRequest.getter(CreateGatewayRouteRequest::clientToken)).setter(CreateGatewayRouteRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> GATEWAY_ROUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gatewayRouteName").getter(CreateGatewayRouteRequest.getter(CreateGatewayRouteRequest::gatewayRouteName)).setter(CreateGatewayRouteRequest.setter(Builder::gatewayRouteName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayRouteName").build()}).build();
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("meshName").getter(CreateGatewayRouteRequest.getter(CreateGatewayRouteRequest::meshName)).setter(CreateGatewayRouteRequest.setter(Builder::meshName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("meshName").build()}).build();
    private static final SdkField<String> MESH_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("meshOwner").getter(CreateGatewayRouteRequest.getter(CreateGatewayRouteRequest::meshOwner)).setter(CreateGatewayRouteRequest.setter(Builder::meshOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("meshOwner").build()}).build();
    private static final SdkField<GatewayRouteSpec> SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("spec").getter(CreateGatewayRouteRequest.getter(CreateGatewayRouteRequest::spec)).setter(CreateGatewayRouteRequest.setter(Builder::spec)).constructor(GatewayRouteSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()}).build();
    private static final SdkField<List<TagRef>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateGatewayRouteRequest.getter(CreateGatewayRouteRequest::tags)).setter(CreateGatewayRouteRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagRef::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VIRTUAL_GATEWAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualGatewayName").getter(CreateGatewayRouteRequest.getter(CreateGatewayRouteRequest::virtualGatewayName)).setter(CreateGatewayRouteRequest.setter(Builder::virtualGatewayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualGatewayName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, GATEWAY_ROUTE_NAME_FIELD, MESH_NAME_FIELD, MESH_OWNER_FIELD, SPEC_FIELD, TAGS_FIELD, VIRTUAL_GATEWAY_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateGatewayRouteRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String gatewayRouteName;
    private final String meshName;
    private final String meshOwner;
    private final GatewayRouteSpec spec;
    private final List<TagRef> tags;
    private final String virtualGatewayName;

    private CreateGatewayRouteRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.gatewayRouteName = builder.gatewayRouteName;
        this.meshName = builder.meshName;
        this.meshOwner = builder.meshOwner;
        this.spec = builder.spec;
        this.tags = builder.tags;
        this.virtualGatewayName = builder.virtualGatewayName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String gatewayRouteName() {
        return this.gatewayRouteName;
    }

    public final String meshName() {
        return this.meshName;
    }

    public final String meshOwner() {
        return this.meshOwner;
    }

    public final GatewayRouteSpec spec() {
        return this.spec;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<TagRef> tags() {
        return this.tags;
    }

    public final String virtualGatewayName() {
        return this.virtualGatewayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayRouteName());
        hashCode = 31 * hashCode + Objects.hashCode(this.meshName());
        hashCode = 31 * hashCode + Objects.hashCode(this.meshOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.spec());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualGatewayName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGatewayRouteRequest)) {
            return false;
        }
        CreateGatewayRouteRequest other = (CreateGatewayRouteRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.gatewayRouteName(), other.gatewayRouteName()) && Objects.equals(this.meshName(), other.meshName()) && Objects.equals(this.meshOwner(), other.meshOwner()) && Objects.equals(this.spec(), other.spec()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.virtualGatewayName(), other.virtualGatewayName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGatewayRouteRequest").add("ClientToken", (Object)this.clientToken()).add("GatewayRouteName", (Object)this.gatewayRouteName()).add("MeshName", (Object)this.meshName()).add("MeshOwner", (Object)this.meshOwner()).add("Spec", (Object)this.spec()).add("Tags", this.hasTags() ? this.tags() : null).add("VirtualGatewayName", (Object)this.virtualGatewayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "gatewayRouteName": {
                return Optional.ofNullable(clazz.cast(this.gatewayRouteName()));
            }
            case "meshName": {
                return Optional.ofNullable(clazz.cast(this.meshName()));
            }
            case "meshOwner": {
                return Optional.ofNullable(clazz.cast(this.meshOwner()));
            }
            case "spec": {
                return Optional.ofNullable(clazz.cast(this.spec()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "virtualGatewayName": {
                return Optional.ofNullable(clazz.cast(this.virtualGatewayName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("gatewayRouteName", GATEWAY_ROUTE_NAME_FIELD);
        map.put("meshName", MESH_NAME_FIELD);
        map.put("meshOwner", MESH_OWNER_FIELD);
        map.put("spec", SPEC_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("virtualGatewayName", VIRTUAL_GATEWAY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGatewayRouteRequest, T> g) {
        return obj -> g.apply((CreateGatewayRouteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppMeshRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String gatewayRouteName;
        private String meshName;
        private String meshOwner;
        private GatewayRouteSpec spec;
        private List<TagRef> tags = DefaultSdkAutoConstructList.getInstance();
        private String virtualGatewayName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGatewayRouteRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.gatewayRouteName(model.gatewayRouteName);
            this.meshName(model.meshName);
            this.meshOwner(model.meshOwner);
            this.spec(model.spec);
            this.tags(model.tags);
            this.virtualGatewayName(model.virtualGatewayName);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getGatewayRouteName() {
            return this.gatewayRouteName;
        }

        public final void setGatewayRouteName(String gatewayRouteName) {
            this.gatewayRouteName = gatewayRouteName;
        }

        @Override
        public final Builder gatewayRouteName(String gatewayRouteName) {
            this.gatewayRouteName = gatewayRouteName;
            return this;
        }

        public final String getMeshName() {
            return this.meshName;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final String getMeshOwner() {
            return this.meshOwner;
        }

        public final void setMeshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
        }

        @Override
        public final Builder meshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
            return this;
        }

        public final GatewayRouteSpec.Builder getSpec() {
            return this.spec != null ? this.spec.toBuilder() : null;
        }

        public final void setSpec(GatewayRouteSpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        @Override
        public final Builder spec(GatewayRouteSpec spec) {
            this.spec = spec;
            return this;
        }

        public final List<TagRef.Builder> getTags() {
            List<TagRef.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<TagRef.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<TagRef> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagRef ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagRef.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (TagRef)((TagRef.Builder)TagRef.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVirtualGatewayName() {
            return this.virtualGatewayName;
        }

        public final void setVirtualGatewayName(String virtualGatewayName) {
            this.virtualGatewayName = virtualGatewayName;
        }

        @Override
        public final Builder virtualGatewayName(String virtualGatewayName) {
            this.virtualGatewayName = virtualGatewayName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGatewayRouteRequest build() {
            return new CreateGatewayRouteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppMeshRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGatewayRouteRequest> {
        public Builder clientToken(String var1);

        public Builder gatewayRouteName(String var1);

        public Builder meshName(String var1);

        public Builder meshOwner(String var1);

        public Builder spec(GatewayRouteSpec var1);

        default public Builder spec(Consumer<GatewayRouteSpec.Builder> spec) {
            return this.spec((GatewayRouteSpec)((GatewayRouteSpec.Builder)GatewayRouteSpec.builder().applyMutation(spec)).build());
        }

        public Builder tags(Collection<TagRef> var1);

        public Builder tags(TagRef ... var1);

        public Builder tags(Consumer<TagRef.Builder> ... var1);

        public Builder virtualGatewayName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

