/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DnsResponseType {
    LOADBALANCER("LOADBALANCER"),
    ENDPOINTS("ENDPOINTS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DnsResponseType> VALUE_MAP;
    private final String value;

    private DnsResponseType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DnsResponseType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DnsResponseType> knownValues() {
        EnumSet<DnsResponseType> knownValues = EnumSet.allOf(DnsResponseType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DnsResponseType.class, DnsResponseType::toString);
    }
}

