/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appmesh.model.ListenerTlsFileCertificate;
import software.amazon.awssdk.services.appmesh.model.ListenerTlsSdsCertificate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClientTlsCertificate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClientTlsCertificate> {
    private static final SdkField<ListenerTlsFileCertificate> FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("file").getter(ClientTlsCertificate.getter(ClientTlsCertificate::file)).setter(ClientTlsCertificate.setter(Builder::file)).constructor(ListenerTlsFileCertificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build()}).build();
    private static final SdkField<ListenerTlsSdsCertificate> SDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sds").getter(ClientTlsCertificate.getter(ClientTlsCertificate::sds)).setter(ClientTlsCertificate.setter(Builder::sds)).constructor(ListenerTlsSdsCertificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_FIELD, SDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final ListenerTlsFileCertificate file;
    private final ListenerTlsSdsCertificate sds;
    private final Type type;

    private ClientTlsCertificate(BuilderImpl builder) {
        this.file = builder.file;
        this.sds = builder.sds;
        this.type = builder.type;
    }

    public final ListenerTlsFileCertificate file() {
        return this.file;
    }

    public final ListenerTlsSdsCertificate sds() {
        return this.sds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.file());
        hashCode = 31 * hashCode + Objects.hashCode(this.sds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientTlsCertificate)) {
            return false;
        }
        ClientTlsCertificate other = (ClientTlsCertificate)obj;
        return Objects.equals(this.file(), other.file()) && Objects.equals(this.sds(), other.sds());
    }

    public final String toString() {
        return ToString.builder((String)"ClientTlsCertificate").add("File", (Object)this.file()).add("Sds", (Object)this.sds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "file": {
                return Optional.ofNullable(clazz.cast(this.file()));
            }
            case "sds": {
                return Optional.ofNullable(clazz.cast(this.sds()));
            }
        }
        return Optional.empty();
    }

    public static ClientTlsCertificate fromFile(ListenerTlsFileCertificate file) {
        return (ClientTlsCertificate)ClientTlsCertificate.builder().file(file).build();
    }

    public static ClientTlsCertificate fromFile(Consumer<ListenerTlsFileCertificate.Builder> file) {
        ListenerTlsFileCertificate.Builder builder = ListenerTlsFileCertificate.builder();
        file.accept(builder);
        return ClientTlsCertificate.fromFile((ListenerTlsFileCertificate)builder.build());
    }

    public static ClientTlsCertificate fromSds(ListenerTlsSdsCertificate sds) {
        return (ClientTlsCertificate)ClientTlsCertificate.builder().sds(sds).build();
    }

    public static ClientTlsCertificate fromSds(Consumer<ListenerTlsSdsCertificate.Builder> sds) {
        ListenerTlsSdsCertificate.Builder builder = ListenerTlsSdsCertificate.builder();
        sds.accept(builder);
        return ClientTlsCertificate.fromSds((ListenerTlsSdsCertificate)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClientTlsCertificate, T> g) {
        return obj -> g.apply((ClientTlsCertificate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        FILE,
        SDS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ListenerTlsFileCertificate file;
        private ListenerTlsSdsCertificate sds;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ClientTlsCertificate model) {
            this.file(model.file);
            this.sds(model.sds);
        }

        public final ListenerTlsFileCertificate.Builder getFile() {
            return this.file != null ? this.file.toBuilder() : null;
        }

        public final void setFile(ListenerTlsFileCertificate.BuilderImpl file) {
            ListenerTlsFileCertificate oldValue = this.file;
            this.file = file != null ? file.build() : null;
            this.handleUnionValueChange(Type.FILE, oldValue, this.file);
        }

        @Override
        public final Builder file(ListenerTlsFileCertificate file) {
            ListenerTlsFileCertificate oldValue = this.file;
            this.file = file;
            this.handleUnionValueChange(Type.FILE, oldValue, this.file);
            return this;
        }

        public final ListenerTlsSdsCertificate.Builder getSds() {
            return this.sds != null ? this.sds.toBuilder() : null;
        }

        public final void setSds(ListenerTlsSdsCertificate.BuilderImpl sds) {
            ListenerTlsSdsCertificate oldValue = this.sds;
            this.sds = sds != null ? sds.build() : null;
            this.handleUnionValueChange(Type.SDS, oldValue, this.sds);
        }

        @Override
        public final Builder sds(ListenerTlsSdsCertificate sds) {
            ListenerTlsSdsCertificate oldValue = this.sds;
            this.sds = sds;
            this.handleUnionValueChange(Type.SDS, oldValue, this.sds);
            return this;
        }

        public ClientTlsCertificate build() {
            return new ClientTlsCertificate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClientTlsCertificate> {
        public Builder file(ListenerTlsFileCertificate var1);

        default public Builder file(Consumer<ListenerTlsFileCertificate.Builder> file) {
            return this.file((ListenerTlsFileCertificate)((ListenerTlsFileCertificate.Builder)ListenerTlsFileCertificate.builder().applyMutation(file)).build());
        }

        public Builder sds(ListenerTlsSdsCertificate var1);

        default public Builder sds(Consumer<ListenerTlsSdsCertificate.Builder> sds) {
            return this.sds((ListenerTlsSdsCertificate)((ListenerTlsSdsCertificate.Builder)ListenerTlsSdsCertificate.builder().applyMutation(sds)).build());
        }
    }
}

