/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.HealthCheckPolicy;
import software.amazon.awssdk.services.appmesh.model.ListenerTimeout;
import software.amazon.awssdk.services.appmesh.model.ListenerTls;
import software.amazon.awssdk.services.appmesh.model.OutlierDetection;
import software.amazon.awssdk.services.appmesh.model.PortMapping;
import software.amazon.awssdk.services.appmesh.model.VirtualNodeConnectionPool;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Listener
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Listener> {
    private static final SdkField<VirtualNodeConnectionPool> CONNECTION_POOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("connectionPool").getter(Listener.getter(Listener::connectionPool)).setter(Listener.setter(Builder::connectionPool)).constructor(VirtualNodeConnectionPool::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionPool").build()}).build();
    private static final SdkField<HealthCheckPolicy> HEALTH_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("healthCheck").getter(Listener.getter(Listener::healthCheck)).setter(Listener.setter(Builder::healthCheck)).constructor(HealthCheckPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheck").build()}).build();
    private static final SdkField<OutlierDetection> OUTLIER_DETECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outlierDetection").getter(Listener.getter(Listener::outlierDetection)).setter(Listener.setter(Builder::outlierDetection)).constructor(OutlierDetection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outlierDetection").build()}).build();
    private static final SdkField<PortMapping> PORT_MAPPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("portMapping").getter(Listener.getter(Listener::portMapping)).setter(Listener.setter(Builder::portMapping)).constructor(PortMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portMapping").build()}).build();
    private static final SdkField<ListenerTimeout> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timeout").getter(Listener.getter(Listener::timeout)).setter(Listener.setter(Builder::timeout)).constructor(ListenerTimeout::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeout").build()}).build();
    private static final SdkField<ListenerTls> TLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tls").getter(Listener.getter(Listener::tls)).setter(Listener.setter(Builder::tls)).constructor(ListenerTls::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tls").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_POOL_FIELD, HEALTH_CHECK_FIELD, OUTLIER_DETECTION_FIELD, PORT_MAPPING_FIELD, TIMEOUT_FIELD, TLS_FIELD));
    private static final long serialVersionUID = 1L;
    private final VirtualNodeConnectionPool connectionPool;
    private final HealthCheckPolicy healthCheck;
    private final OutlierDetection outlierDetection;
    private final PortMapping portMapping;
    private final ListenerTimeout timeout;
    private final ListenerTls tls;

    private Listener(BuilderImpl builder) {
        this.connectionPool = builder.connectionPool;
        this.healthCheck = builder.healthCheck;
        this.outlierDetection = builder.outlierDetection;
        this.portMapping = builder.portMapping;
        this.timeout = builder.timeout;
        this.tls = builder.tls;
    }

    public final VirtualNodeConnectionPool connectionPool() {
        return this.connectionPool;
    }

    public final HealthCheckPolicy healthCheck() {
        return this.healthCheck;
    }

    public final OutlierDetection outlierDetection() {
        return this.outlierDetection;
    }

    public final PortMapping portMapping() {
        return this.portMapping;
    }

    public final ListenerTimeout timeout() {
        return this.timeout;
    }

    public final ListenerTls tls() {
        return this.tls;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionPool());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.outlierDetection());
        hashCode = 31 * hashCode + Objects.hashCode(this.portMapping());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.tls());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Listener)) {
            return false;
        }
        Listener other = (Listener)obj;
        return Objects.equals(this.connectionPool(), other.connectionPool()) && Objects.equals(this.healthCheck(), other.healthCheck()) && Objects.equals(this.outlierDetection(), other.outlierDetection()) && Objects.equals(this.portMapping(), other.portMapping()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.tls(), other.tls());
    }

    public final String toString() {
        return ToString.builder((String)"Listener").add("ConnectionPool", (Object)this.connectionPool()).add("HealthCheck", (Object)this.healthCheck()).add("OutlierDetection", (Object)this.outlierDetection()).add("PortMapping", (Object)this.portMapping()).add("Timeout", (Object)this.timeout()).add("Tls", (Object)this.tls()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionPool": {
                return Optional.ofNullable(clazz.cast(this.connectionPool()));
            }
            case "healthCheck": {
                return Optional.ofNullable(clazz.cast(this.healthCheck()));
            }
            case "outlierDetection": {
                return Optional.ofNullable(clazz.cast(this.outlierDetection()));
            }
            case "portMapping": {
                return Optional.ofNullable(clazz.cast(this.portMapping()));
            }
            case "timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "tls": {
                return Optional.ofNullable(clazz.cast(this.tls()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Listener, T> g) {
        return obj -> g.apply((Listener)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private VirtualNodeConnectionPool connectionPool;
        private HealthCheckPolicy healthCheck;
        private OutlierDetection outlierDetection;
        private PortMapping portMapping;
        private ListenerTimeout timeout;
        private ListenerTls tls;

        private BuilderImpl() {
        }

        private BuilderImpl(Listener model) {
            this.connectionPool(model.connectionPool);
            this.healthCheck(model.healthCheck);
            this.outlierDetection(model.outlierDetection);
            this.portMapping(model.portMapping);
            this.timeout(model.timeout);
            this.tls(model.tls);
        }

        public final VirtualNodeConnectionPool.Builder getConnectionPool() {
            return this.connectionPool != null ? this.connectionPool.toBuilder() : null;
        }

        @Override
        public final Builder connectionPool(VirtualNodeConnectionPool connectionPool) {
            this.connectionPool = connectionPool;
            return this;
        }

        public final void setConnectionPool(VirtualNodeConnectionPool.BuilderImpl connectionPool) {
            this.connectionPool = connectionPool != null ? connectionPool.build() : null;
        }

        public final HealthCheckPolicy.Builder getHealthCheck() {
            return this.healthCheck != null ? this.healthCheck.toBuilder() : null;
        }

        @Override
        public final Builder healthCheck(HealthCheckPolicy healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final void setHealthCheck(HealthCheckPolicy.BuilderImpl healthCheck) {
            this.healthCheck = healthCheck != null ? healthCheck.build() : null;
        }

        public final OutlierDetection.Builder getOutlierDetection() {
            return this.outlierDetection != null ? this.outlierDetection.toBuilder() : null;
        }

        @Override
        public final Builder outlierDetection(OutlierDetection outlierDetection) {
            this.outlierDetection = outlierDetection;
            return this;
        }

        public final void setOutlierDetection(OutlierDetection.BuilderImpl outlierDetection) {
            this.outlierDetection = outlierDetection != null ? outlierDetection.build() : null;
        }

        public final PortMapping.Builder getPortMapping() {
            return this.portMapping != null ? this.portMapping.toBuilder() : null;
        }

        @Override
        public final Builder portMapping(PortMapping portMapping) {
            this.portMapping = portMapping;
            return this;
        }

        public final void setPortMapping(PortMapping.BuilderImpl portMapping) {
            this.portMapping = portMapping != null ? portMapping.build() : null;
        }

        public final ListenerTimeout.Builder getTimeout() {
            return this.timeout != null ? this.timeout.toBuilder() : null;
        }

        @Override
        public final Builder timeout(ListenerTimeout timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(ListenerTimeout.BuilderImpl timeout) {
            this.timeout = timeout != null ? timeout.build() : null;
        }

        public final ListenerTls.Builder getTls() {
            return this.tls != null ? this.tls.toBuilder() : null;
        }

        @Override
        public final Builder tls(ListenerTls tls) {
            this.tls = tls;
            return this;
        }

        public final void setTls(ListenerTls.BuilderImpl tls) {
            this.tls = tls != null ? tls.build() : null;
        }

        public Listener build() {
            return new Listener(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Listener> {
        public Builder connectionPool(VirtualNodeConnectionPool var1);

        default public Builder connectionPool(Consumer<VirtualNodeConnectionPool.Builder> connectionPool) {
            return this.connectionPool((VirtualNodeConnectionPool)((VirtualNodeConnectionPool.Builder)VirtualNodeConnectionPool.builder().applyMutation(connectionPool)).build());
        }

        public Builder healthCheck(HealthCheckPolicy var1);

        default public Builder healthCheck(Consumer<HealthCheckPolicy.Builder> healthCheck) {
            return this.healthCheck((HealthCheckPolicy)((HealthCheckPolicy.Builder)HealthCheckPolicy.builder().applyMutation(healthCheck)).build());
        }

        public Builder outlierDetection(OutlierDetection var1);

        default public Builder outlierDetection(Consumer<OutlierDetection.Builder> outlierDetection) {
            return this.outlierDetection((OutlierDetection)((OutlierDetection.Builder)OutlierDetection.builder().applyMutation(outlierDetection)).build());
        }

        public Builder portMapping(PortMapping var1);

        default public Builder portMapping(Consumer<PortMapping.Builder> portMapping) {
            return this.portMapping((PortMapping)((PortMapping.Builder)PortMapping.builder().applyMutation(portMapping)).build());
        }

        public Builder timeout(ListenerTimeout var1);

        default public Builder timeout(Consumer<ListenerTimeout.Builder> timeout) {
            return this.timeout((ListenerTimeout)((ListenerTimeout.Builder)ListenerTimeout.builder().applyMutation(timeout)).build());
        }

        public Builder tls(ListenerTls var1);

        default public Builder tls(Consumer<ListenerTls.Builder> tls) {
            return this.tls((ListenerTls)((ListenerTls.Builder)ListenerTls.builder().applyMutation(tls)).build());
        }
    }
}

