/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.appmesh.AppMeshClient;
import software.amazon.awssdk.services.appmesh.model.AppMeshException;
import software.amazon.awssdk.services.appmesh.model.AppMeshRequest;
import software.amazon.awssdk.services.appmesh.model.BadRequestException;
import software.amazon.awssdk.services.appmesh.model.ConflictException;
import software.amazon.awssdk.services.appmesh.model.CreateGatewayRouteRequest;
import software.amazon.awssdk.services.appmesh.model.CreateGatewayRouteResponse;
import software.amazon.awssdk.services.appmesh.model.CreateMeshRequest;
import software.amazon.awssdk.services.appmesh.model.CreateMeshResponse;
import software.amazon.awssdk.services.appmesh.model.CreateRouteRequest;
import software.amazon.awssdk.services.appmesh.model.CreateRouteResponse;
import software.amazon.awssdk.services.appmesh.model.CreateVirtualGatewayRequest;
import software.amazon.awssdk.services.appmesh.model.CreateVirtualGatewayResponse;
import software.amazon.awssdk.services.appmesh.model.CreateVirtualNodeRequest;
import software.amazon.awssdk.services.appmesh.model.CreateVirtualNodeResponse;
import software.amazon.awssdk.services.appmesh.model.CreateVirtualRouterRequest;
import software.amazon.awssdk.services.appmesh.model.CreateVirtualRouterResponse;
import software.amazon.awssdk.services.appmesh.model.CreateVirtualServiceRequest;
import software.amazon.awssdk.services.appmesh.model.CreateVirtualServiceResponse;
import software.amazon.awssdk.services.appmesh.model.DeleteGatewayRouteRequest;
import software.amazon.awssdk.services.appmesh.model.DeleteGatewayRouteResponse;
import software.amazon.awssdk.services.appmesh.model.DeleteMeshRequest;
import software.amazon.awssdk.services.appmesh.model.DeleteMeshResponse;
import software.amazon.awssdk.services.appmesh.model.DeleteRouteRequest;
import software.amazon.awssdk.services.appmesh.model.DeleteRouteResponse;
import software.amazon.awssdk.services.appmesh.model.DeleteVirtualGatewayRequest;
import software.amazon.awssdk.services.appmesh.model.DeleteVirtualGatewayResponse;
import software.amazon.awssdk.services.appmesh.model.DeleteVirtualNodeRequest;
import software.amazon.awssdk.services.appmesh.model.DeleteVirtualNodeResponse;
import software.amazon.awssdk.services.appmesh.model.DeleteVirtualRouterRequest;
import software.amazon.awssdk.services.appmesh.model.DeleteVirtualRouterResponse;
import software.amazon.awssdk.services.appmesh.model.DeleteVirtualServiceRequest;
import software.amazon.awssdk.services.appmesh.model.DeleteVirtualServiceResponse;
import software.amazon.awssdk.services.appmesh.model.DescribeGatewayRouteRequest;
import software.amazon.awssdk.services.appmesh.model.DescribeGatewayRouteResponse;
import software.amazon.awssdk.services.appmesh.model.DescribeMeshRequest;
import software.amazon.awssdk.services.appmesh.model.DescribeMeshResponse;
import software.amazon.awssdk.services.appmesh.model.DescribeRouteRequest;
import software.amazon.awssdk.services.appmesh.model.DescribeRouteResponse;
import software.amazon.awssdk.services.appmesh.model.DescribeVirtualGatewayRequest;
import software.amazon.awssdk.services.appmesh.model.DescribeVirtualGatewayResponse;
import software.amazon.awssdk.services.appmesh.model.DescribeVirtualNodeRequest;
import software.amazon.awssdk.services.appmesh.model.DescribeVirtualNodeResponse;
import software.amazon.awssdk.services.appmesh.model.DescribeVirtualRouterRequest;
import software.amazon.awssdk.services.appmesh.model.DescribeVirtualRouterResponse;
import software.amazon.awssdk.services.appmesh.model.DescribeVirtualServiceRequest;
import software.amazon.awssdk.services.appmesh.model.DescribeVirtualServiceResponse;
import software.amazon.awssdk.services.appmesh.model.ForbiddenException;
import software.amazon.awssdk.services.appmesh.model.InternalServerErrorException;
import software.amazon.awssdk.services.appmesh.model.LimitExceededException;
import software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesRequest;
import software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesResponse;
import software.amazon.awssdk.services.appmesh.model.ListMeshesRequest;
import software.amazon.awssdk.services.appmesh.model.ListMeshesResponse;
import software.amazon.awssdk.services.appmesh.model.ListRoutesRequest;
import software.amazon.awssdk.services.appmesh.model.ListRoutesResponse;
import software.amazon.awssdk.services.appmesh.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.appmesh.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.appmesh.model.ListVirtualGatewaysRequest;
import software.amazon.awssdk.services.appmesh.model.ListVirtualGatewaysResponse;
import software.amazon.awssdk.services.appmesh.model.ListVirtualNodesRequest;
import software.amazon.awssdk.services.appmesh.model.ListVirtualNodesResponse;
import software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersRequest;
import software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersResponse;
import software.amazon.awssdk.services.appmesh.model.ListVirtualServicesRequest;
import software.amazon.awssdk.services.appmesh.model.ListVirtualServicesResponse;
import software.amazon.awssdk.services.appmesh.model.NotFoundException;
import software.amazon.awssdk.services.appmesh.model.ResourceInUseException;
import software.amazon.awssdk.services.appmesh.model.ServiceUnavailableException;
import software.amazon.awssdk.services.appmesh.model.TagResourceRequest;
import software.amazon.awssdk.services.appmesh.model.TagResourceResponse;
import software.amazon.awssdk.services.appmesh.model.TooManyRequestsException;
import software.amazon.awssdk.services.appmesh.model.TooManyTagsException;
import software.amazon.awssdk.services.appmesh.model.UntagResourceRequest;
import software.amazon.awssdk.services.appmesh.model.UntagResourceResponse;
import software.amazon.awssdk.services.appmesh.model.UpdateGatewayRouteRequest;
import software.amazon.awssdk.services.appmesh.model.UpdateGatewayRouteResponse;
import software.amazon.awssdk.services.appmesh.model.UpdateMeshRequest;
import software.amazon.awssdk.services.appmesh.model.UpdateMeshResponse;
import software.amazon.awssdk.services.appmesh.model.UpdateRouteRequest;
import software.amazon.awssdk.services.appmesh.model.UpdateRouteResponse;
import software.amazon.awssdk.services.appmesh.model.UpdateVirtualGatewayRequest;
import software.amazon.awssdk.services.appmesh.model.UpdateVirtualGatewayResponse;
import software.amazon.awssdk.services.appmesh.model.UpdateVirtualNodeRequest;
import software.amazon.awssdk.services.appmesh.model.UpdateVirtualNodeResponse;
import software.amazon.awssdk.services.appmesh.model.UpdateVirtualRouterRequest;
import software.amazon.awssdk.services.appmesh.model.UpdateVirtualRouterResponse;
import software.amazon.awssdk.services.appmesh.model.UpdateVirtualServiceRequest;
import software.amazon.awssdk.services.appmesh.model.UpdateVirtualServiceResponse;
import software.amazon.awssdk.services.appmesh.paginators.ListGatewayRoutesIterable;
import software.amazon.awssdk.services.appmesh.paginators.ListMeshesIterable;
import software.amazon.awssdk.services.appmesh.paginators.ListRoutesIterable;
import software.amazon.awssdk.services.appmesh.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.appmesh.paginators.ListVirtualGatewaysIterable;
import software.amazon.awssdk.services.appmesh.paginators.ListVirtualNodesIterable;
import software.amazon.awssdk.services.appmesh.paginators.ListVirtualRoutersIterable;
import software.amazon.awssdk.services.appmesh.paginators.ListVirtualServicesIterable;
import software.amazon.awssdk.services.appmesh.transform.CreateGatewayRouteRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.CreateMeshRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.CreateRouteRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.CreateVirtualGatewayRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.CreateVirtualNodeRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.CreateVirtualRouterRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.CreateVirtualServiceRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DeleteGatewayRouteRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DeleteMeshRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DeleteRouteRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DeleteVirtualGatewayRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DeleteVirtualNodeRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DeleteVirtualRouterRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DeleteVirtualServiceRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DescribeGatewayRouteRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DescribeMeshRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DescribeRouteRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DescribeVirtualGatewayRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DescribeVirtualNodeRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DescribeVirtualRouterRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DescribeVirtualServiceRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.ListGatewayRoutesRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.ListMeshesRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.ListRoutesRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.ListVirtualGatewaysRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.ListVirtualNodesRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.ListVirtualRoutersRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.ListVirtualServicesRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.UpdateGatewayRouteRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.UpdateMeshRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.UpdateRouteRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.UpdateVirtualGatewayRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.UpdateVirtualNodeRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.UpdateVirtualRouterRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.UpdateVirtualServiceRequestMarshaller;

@SdkInternalApi
final class DefaultAppMeshClient
implements AppMeshClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAppMeshClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "appmesh";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGatewayRouteResponse createGatewayRoute(CreateGatewayRouteRequest createGatewayRouteRequest) throws BadRequestException, ConflictException, ForbiddenException, InternalServerErrorException, LimitExceededException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGatewayRouteResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, createGatewayRouteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGatewayRoute");
            CreateGatewayRouteResponse createGatewayRouteResponse = (CreateGatewayRouteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGatewayRoute").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGatewayRouteRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateGatewayRouteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGatewayRouteResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$createGatewayRoute$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMeshResponse createMesh(CreateMeshRequest createMeshRequest) throws BadRequestException, ConflictException, ForbiddenException, InternalServerErrorException, LimitExceededException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMeshResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, createMeshRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMesh");
            CreateMeshResponse createMeshResponse = (CreateMeshResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMesh").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createMeshRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateMeshRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMeshResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$createMesh$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRouteResponse createRoute(CreateRouteRequest createRouteRequest) throws BadRequestException, ConflictException, ForbiddenException, InternalServerErrorException, LimitExceededException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRouteResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, createRouteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRoute");
            CreateRouteResponse createRouteResponse = (CreateRouteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRoute").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createRouteRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateRouteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createRouteResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$createRoute$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVirtualGatewayResponse createVirtualGateway(CreateVirtualGatewayRequest createVirtualGatewayRequest) throws BadRequestException, ConflictException, ForbiddenException, InternalServerErrorException, LimitExceededException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVirtualGatewayResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, createVirtualGatewayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVirtualGateway");
            CreateVirtualGatewayResponse createVirtualGatewayResponse = (CreateVirtualGatewayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVirtualGateway").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createVirtualGatewayRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateVirtualGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createVirtualGatewayResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$createVirtualGateway$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVirtualNodeResponse createVirtualNode(CreateVirtualNodeRequest createVirtualNodeRequest) throws BadRequestException, ConflictException, ForbiddenException, InternalServerErrorException, LimitExceededException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVirtualNodeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, createVirtualNodeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVirtualNode");
            CreateVirtualNodeResponse createVirtualNodeResponse = (CreateVirtualNodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVirtualNode").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createVirtualNodeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateVirtualNodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createVirtualNodeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$createVirtualNode$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVirtualRouterResponse createVirtualRouter(CreateVirtualRouterRequest createVirtualRouterRequest) throws BadRequestException, ConflictException, ForbiddenException, InternalServerErrorException, LimitExceededException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVirtualRouterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, createVirtualRouterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVirtualRouter");
            CreateVirtualRouterResponse createVirtualRouterResponse = (CreateVirtualRouterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVirtualRouter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createVirtualRouterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateVirtualRouterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createVirtualRouterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$createVirtualRouter$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVirtualServiceResponse createVirtualService(CreateVirtualServiceRequest createVirtualServiceRequest) throws BadRequestException, ConflictException, ForbiddenException, InternalServerErrorException, LimitExceededException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVirtualServiceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, createVirtualServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVirtualService");
            CreateVirtualServiceResponse createVirtualServiceResponse = (CreateVirtualServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVirtualService").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createVirtualServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateVirtualServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createVirtualServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$createVirtualService$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteGatewayRouteResponse deleteGatewayRoute(DeleteGatewayRouteRequest deleteGatewayRouteRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ResourceInUseException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGatewayRouteResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, deleteGatewayRouteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteGatewayRoute");
            DeleteGatewayRouteResponse deleteGatewayRouteResponse = (DeleteGatewayRouteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGatewayRoute").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteGatewayRouteRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteGatewayRouteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteGatewayRouteResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$deleteGatewayRoute$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMeshResponse deleteMesh(DeleteMeshRequest deleteMeshRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ResourceInUseException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMeshResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, deleteMeshRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMesh");
            DeleteMeshResponse deleteMeshResponse = (DeleteMeshResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMesh").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteMeshRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteMeshRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteMeshResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$deleteMesh$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRouteResponse deleteRoute(DeleteRouteRequest deleteRouteRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ResourceInUseException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRouteResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, deleteRouteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRoute");
            DeleteRouteResponse deleteRouteResponse = (DeleteRouteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRoute").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRouteRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRouteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRouteResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$deleteRoute$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVirtualGatewayResponse deleteVirtualGateway(DeleteVirtualGatewayRequest deleteVirtualGatewayRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ResourceInUseException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVirtualGatewayResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, deleteVirtualGatewayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVirtualGateway");
            DeleteVirtualGatewayResponse deleteVirtualGatewayResponse = (DeleteVirtualGatewayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVirtualGateway").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteVirtualGatewayRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVirtualGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteVirtualGatewayResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$deleteVirtualGateway$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVirtualNodeResponse deleteVirtualNode(DeleteVirtualNodeRequest deleteVirtualNodeRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ResourceInUseException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVirtualNodeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, deleteVirtualNodeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVirtualNode");
            DeleteVirtualNodeResponse deleteVirtualNodeResponse = (DeleteVirtualNodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVirtualNode").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteVirtualNodeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVirtualNodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteVirtualNodeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$deleteVirtualNode$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVirtualRouterResponse deleteVirtualRouter(DeleteVirtualRouterRequest deleteVirtualRouterRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ResourceInUseException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVirtualRouterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, deleteVirtualRouterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVirtualRouter");
            DeleteVirtualRouterResponse deleteVirtualRouterResponse = (DeleteVirtualRouterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVirtualRouter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteVirtualRouterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVirtualRouterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteVirtualRouterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$deleteVirtualRouter$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVirtualServiceResponse deleteVirtualService(DeleteVirtualServiceRequest deleteVirtualServiceRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ResourceInUseException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVirtualServiceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, deleteVirtualServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVirtualService");
            DeleteVirtualServiceResponse deleteVirtualServiceResponse = (DeleteVirtualServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVirtualService").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteVirtualServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVirtualServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteVirtualServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$deleteVirtualService$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeGatewayRouteResponse describeGatewayRoute(DescribeGatewayRouteRequest describeGatewayRouteRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGatewayRouteResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, describeGatewayRouteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeGatewayRoute");
            DescribeGatewayRouteResponse describeGatewayRouteResponse = (DescribeGatewayRouteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGatewayRoute").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeGatewayRouteRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeGatewayRouteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeGatewayRouteResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$describeGatewayRoute$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMeshResponse describeMesh(DescribeMeshRequest describeMeshRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMeshResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, describeMeshRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMesh");
            DescribeMeshResponse describeMeshResponse = (DescribeMeshResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMesh").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeMeshRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMeshRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMeshResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$describeMesh$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRouteResponse describeRoute(DescribeRouteRequest describeRouteRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRouteResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, describeRouteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRoute");
            DescribeRouteResponse describeRouteResponse = (DescribeRouteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRoute").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRouteRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRouteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRouteResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$describeRoute$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVirtualGatewayResponse describeVirtualGateway(DescribeVirtualGatewayRequest describeVirtualGatewayRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVirtualGatewayResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, describeVirtualGatewayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeVirtualGateway");
            DescribeVirtualGatewayResponse describeVirtualGatewayResponse = (DescribeVirtualGatewayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeVirtualGateway").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeVirtualGatewayRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeVirtualGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeVirtualGatewayResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$describeVirtualGateway$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVirtualNodeResponse describeVirtualNode(DescribeVirtualNodeRequest describeVirtualNodeRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVirtualNodeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, describeVirtualNodeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeVirtualNode");
            DescribeVirtualNodeResponse describeVirtualNodeResponse = (DescribeVirtualNodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeVirtualNode").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeVirtualNodeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeVirtualNodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeVirtualNodeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$describeVirtualNode$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVirtualRouterResponse describeVirtualRouter(DescribeVirtualRouterRequest describeVirtualRouterRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVirtualRouterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, describeVirtualRouterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeVirtualRouter");
            DescribeVirtualRouterResponse describeVirtualRouterResponse = (DescribeVirtualRouterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeVirtualRouter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeVirtualRouterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeVirtualRouterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeVirtualRouterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$describeVirtualRouter$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVirtualServiceResponse describeVirtualService(DescribeVirtualServiceRequest describeVirtualServiceRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVirtualServiceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, describeVirtualServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeVirtualService");
            DescribeVirtualServiceResponse describeVirtualServiceResponse = (DescribeVirtualServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeVirtualService").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeVirtualServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeVirtualServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeVirtualServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$describeVirtualService$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGatewayRoutesResponse listGatewayRoutes(ListGatewayRoutesRequest listGatewayRoutesRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGatewayRoutesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, listGatewayRoutesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGatewayRoutes");
            ListGatewayRoutesResponse listGatewayRoutesResponse = (ListGatewayRoutesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGatewayRoutes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listGatewayRoutesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListGatewayRoutesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGatewayRoutesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$listGatewayRoutes$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListGatewayRoutesIterable listGatewayRoutesPaginator(ListGatewayRoutesRequest listGatewayRoutesRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        return new ListGatewayRoutesIterable(this, this.applyPaginatorUserAgent(listGatewayRoutesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMeshesResponse listMeshes(ListMeshesRequest listMeshesRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMeshesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, listMeshesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMeshes");
            ListMeshesResponse listMeshesResponse = (ListMeshesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMeshes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMeshesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMeshesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMeshesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$listMeshes$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListMeshesIterable listMeshesPaginator(ListMeshesRequest listMeshesRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        return new ListMeshesIterable(this, this.applyPaginatorUserAgent(listMeshesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRoutesResponse listRoutes(ListRoutesRequest listRoutesRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRoutesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, listRoutesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRoutes");
            ListRoutesResponse listRoutesResponse = (ListRoutesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRoutes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRoutesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRoutesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRoutesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$listRoutes$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListRoutesIterable listRoutesPaginator(ListRoutesRequest listRoutesRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        return new ListRoutesIterable(this, this.applyPaginatorUserAgent(listRoutesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$listTagsForResource$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        return new ListTagsForResourceIterable(this, this.applyPaginatorUserAgent(listTagsForResourceRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVirtualGatewaysResponse listVirtualGateways(ListVirtualGatewaysRequest listVirtualGatewaysRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVirtualGatewaysResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, listVirtualGatewaysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVirtualGateways");
            ListVirtualGatewaysResponse listVirtualGatewaysResponse = (ListVirtualGatewaysResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVirtualGateways").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listVirtualGatewaysRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListVirtualGatewaysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVirtualGatewaysResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$listVirtualGateways$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListVirtualGatewaysIterable listVirtualGatewaysPaginator(ListVirtualGatewaysRequest listVirtualGatewaysRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        return new ListVirtualGatewaysIterable(this, this.applyPaginatorUserAgent(listVirtualGatewaysRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVirtualNodesResponse listVirtualNodes(ListVirtualNodesRequest listVirtualNodesRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVirtualNodesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, listVirtualNodesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVirtualNodes");
            ListVirtualNodesResponse listVirtualNodesResponse = (ListVirtualNodesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVirtualNodes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listVirtualNodesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListVirtualNodesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVirtualNodesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$listVirtualNodes$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListVirtualNodesIterable listVirtualNodesPaginator(ListVirtualNodesRequest listVirtualNodesRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        return new ListVirtualNodesIterable(this, this.applyPaginatorUserAgent(listVirtualNodesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVirtualRoutersResponse listVirtualRouters(ListVirtualRoutersRequest listVirtualRoutersRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVirtualRoutersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, listVirtualRoutersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVirtualRouters");
            ListVirtualRoutersResponse listVirtualRoutersResponse = (ListVirtualRoutersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVirtualRouters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listVirtualRoutersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListVirtualRoutersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVirtualRoutersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$listVirtualRouters$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListVirtualRoutersIterable listVirtualRoutersPaginator(ListVirtualRoutersRequest listVirtualRoutersRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        return new ListVirtualRoutersIterable(this, this.applyPaginatorUserAgent(listVirtualRoutersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVirtualServicesResponse listVirtualServices(ListVirtualServicesRequest listVirtualServicesRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVirtualServicesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, listVirtualServicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVirtualServices");
            ListVirtualServicesResponse listVirtualServicesResponse = (ListVirtualServicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVirtualServices").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listVirtualServicesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListVirtualServicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVirtualServicesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$listVirtualServices$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListVirtualServicesIterable listVirtualServicesPaginator(ListVirtualServicesRequest listVirtualServicesRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        return new ListVirtualServicesIterable(this, this.applyPaginatorUserAgent(listVirtualServicesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, TooManyTagsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$tagResource$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$untagResource$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGatewayRouteResponse updateGatewayRoute(UpdateGatewayRouteRequest updateGatewayRouteRequest) throws BadRequestException, ConflictException, ForbiddenException, InternalServerErrorException, LimitExceededException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGatewayRouteResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, updateGatewayRouteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGatewayRoute");
            UpdateGatewayRouteResponse updateGatewayRouteResponse = (UpdateGatewayRouteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGatewayRoute").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateGatewayRouteRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGatewayRouteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGatewayRouteResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$updateGatewayRoute$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateMeshResponse updateMesh(UpdateMeshRequest updateMeshRequest) throws BadRequestException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateMeshResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, updateMeshRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateMesh");
            UpdateMeshResponse updateMeshResponse = (UpdateMeshResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateMesh").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateMeshRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateMeshRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateMeshResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$updateMesh$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRouteResponse updateRoute(UpdateRouteRequest updateRouteRequest) throws BadRequestException, ConflictException, ForbiddenException, InternalServerErrorException, LimitExceededException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRouteResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, updateRouteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRoute");
            UpdateRouteResponse updateRouteResponse = (UpdateRouteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRoute").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateRouteRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateRouteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateRouteResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$updateRoute$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateVirtualGatewayResponse updateVirtualGateway(UpdateVirtualGatewayRequest updateVirtualGatewayRequest) throws BadRequestException, ConflictException, ForbiddenException, InternalServerErrorException, LimitExceededException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateVirtualGatewayResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, updateVirtualGatewayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateVirtualGateway");
            UpdateVirtualGatewayResponse updateVirtualGatewayResponse = (UpdateVirtualGatewayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateVirtualGateway").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateVirtualGatewayRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateVirtualGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateVirtualGatewayResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$updateVirtualGateway$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateVirtualNodeResponse updateVirtualNode(UpdateVirtualNodeRequest updateVirtualNodeRequest) throws BadRequestException, ConflictException, ForbiddenException, InternalServerErrorException, LimitExceededException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateVirtualNodeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, updateVirtualNodeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateVirtualNode");
            UpdateVirtualNodeResponse updateVirtualNodeResponse = (UpdateVirtualNodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateVirtualNode").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateVirtualNodeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateVirtualNodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateVirtualNodeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$updateVirtualNode$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateVirtualRouterResponse updateVirtualRouter(UpdateVirtualRouterRequest updateVirtualRouterRequest) throws BadRequestException, ConflictException, ForbiddenException, InternalServerErrorException, LimitExceededException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateVirtualRouterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, updateVirtualRouterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateVirtualRouter");
            UpdateVirtualRouterResponse updateVirtualRouterResponse = (UpdateVirtualRouterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateVirtualRouter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateVirtualRouterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateVirtualRouterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateVirtualRouterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$updateVirtualRouter$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateVirtualServiceResponse updateVirtualService(UpdateVirtualServiceRequest updateVirtualServiceRequest) throws BadRequestException, ConflictException, ForbiddenException, InternalServerErrorException, LimitExceededException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateVirtualServiceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(this.clientConfiguration, updateVirtualServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateVirtualService");
            UpdateVirtualServiceResponse updateVirtualServiceResponse = (UpdateVirtualServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateVirtualService").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateVirtualServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateVirtualServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateVirtualServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$updateVirtualService$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AppMeshException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ForbiddenException").exceptionBuilderSupplier(ForbiddenException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUseException").exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsException").exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(Integer.valueOf(503)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BadRequestException").exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerErrorException").exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends AppMeshRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.70").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((AppMeshRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateVirtualService$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateVirtualRouter$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateVirtualNode$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateVirtualGateway$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRoute$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateMesh$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGatewayRoute$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVirtualServices$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVirtualRouters$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVirtualNodes$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVirtualGateways$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRoutes$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMeshes$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGatewayRoutes$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeVirtualService$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeVirtualRouter$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeVirtualNode$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeVirtualGateway$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRoute$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMesh$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeGatewayRoute$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVirtualService$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVirtualRouter$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVirtualNode$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVirtualGateway$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRoute$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMesh$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteGatewayRoute$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createVirtualService$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createVirtualRouter$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createVirtualNode$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createVirtualGateway$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRoute$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMesh$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGatewayRoute$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

