/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTagsForResourceResponse extends AppMeshResponse implements
        ToCopyableBuilder<ListTagsForResourceResponse.Builder, ListTagsForResourceResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTagsForResourceResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<TagRef>> TAGS_FIELD = SdkField
            .<List<TagRef>> builder(MarshallingType.LIST)
            .getter(getter(ListTagsForResourceResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagRef> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagRef::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TAGS_FIELD));

    private final String nextToken;

    private final List<TagRef> tags;

    private ListTagsForResourceResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListTagsForResource</code> request. When the
     * results of a <code>ListTagsForResource</code> request exceed <code>limit</code>, you can use this value to
     * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListTagsForResource</code> request. When
     *         the results of a <code>ListTagsForResource</code> request exceed <code>limit</code>, you can use this
     *         value to retrieve the next page of results. This value is <code>null</code> when there are no more
     *         results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags for the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags for the resource.
     */
    public List<TagRef> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourceResponse)) {
            return false;
        }
        ListTagsForResourceResponse other = (ListTagsForResourceResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListTagsForResourceResponse").add("NextToken", nextToken()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTagsForResourceResponse, T> g) {
        return obj -> g.apply((ListTagsForResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTagsForResourceResponse> {
        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListTagsForResource</code> request. When the
         * results of a <code>ListTagsForResource</code> request exceed <code>limit</code>, you can use this value to
         * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListTagsForResource</code> request. When
         *        the results of a <code>ListTagsForResource</code> request exceed <code>limit</code>, you can use this
         *        value to retrieve the next page of results. This value is <code>null</code> when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The tags for the resource.
         * </p>
         * 
         * @param tags
         *        The tags for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<TagRef> tags);

        /**
         * <p>
         * The tags for the resource.
         * </p>
         * 
         * @param tags
         *        The tags for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagRef... tags);

        /**
         * <p>
         * The tags for the resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagRef>.Builder} avoiding the need to
         * create one manually via {@link List<TagRef>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagRef>.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<TagRef>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<TagRef>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<TagRef>)
         */
        Builder tags(Consumer<TagRef.Builder>... tags);
    }

    static final class BuilderImpl extends AppMeshResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<TagRef> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForResourceResponse model) {
            super(model);
            nextToken(model.nextToken);
            tags(model.tags);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<TagRef.Builder> getTags() {
            return tags != null ? tags.stream().map(TagRef::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<TagRef> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagRef... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagRef.Builder>... tags) {
            tags(Stream.of(tags).map(c -> TagRef.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<TagRef.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public ListTagsForResourceResponse build() {
            return new ListTagsForResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
