/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PortProtocol {
    GRPC("grpc"),
    HTTP("http"),
    HTTP2("http2"),
    TCP("tcp"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private PortProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PortProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(PortProtocol.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PortProtocol> knownValues() {
        return Stream.of(PortProtocol.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

