/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ChangeEventType {
    DEPLOYMENT("DEPLOYMENT"),
    CONFIGURATION("CONFIGURATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ChangeEventType> VALUE_MAP;
    private final String value;

    private ChangeEventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ChangeEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ChangeEventType> knownValues() {
        EnumSet<ChangeEventType> knownValues = EnumSet.allOf(ChangeEventType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ChangeEventType.class, ChangeEventType::toString);
    }
}

